﻿---
title: Windows System Network Connections Discovery
description: This rule identifies the execution of commands that can be used to enumerate network connections. Adversaries may attempt to get a listing of network...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_win_network_connections
products:
  - Elastic Security
---

# Windows System Network Connections Discovery
This rule identifies the execution of commands that can be used to enumerate network connections. Adversaries may
attempt to get a listing of network connections to or from a compromised system to identify targets within an
environment.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.process-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Discovery
- Rule Type: BBR
- Data Source: Elastic Defend

**Version**: 6
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```eql
process where event.type == "start" and
(
  process.name : "netstat.exe" or
  (
   (
    (process.name : "net.exe" or process.pe.original_file_name == "net.exe") or
    (
     (process.name : "net1.exe" or process.pe.original_file_name == "net1.exe") and
     not process.parent.name : "net.exe"
    )
   ) and process.args : ("use", "user", "session", "config") and not process.args: ("/persistent:*", "/delete", "\\\\*")
  ) or
  (process.name : "nbtstat.exe" and process.args : "-s*")
) and not user.id : "S-1-5-18"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: System Network Connections Discovery
- Id: T1049
- Reference URL: [[https://attack.mitre.org/techniques/T1049/](https://attack.mitre.org/techniques/T1049/)](https://attack.mitre.org/techniques/T1049/)
- Technique:
  - Name: System Information Discovery
- Id: T1082
- Reference URL: [[https://attack.mitre.org/techniques/T1082/](https://attack.mitre.org/techniques/T1082/)](https://attack.mitre.org/techniques/T1082/)