﻿---
title: System Time Discovery
description: Detects the usage of commonly used system time discovery techniques, which attackers may use during the reconnaissance phase after compromising a system...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_system_time_discovery
products:
  - Elastic Security
---

# System Time Discovery
Detects the usage of commonly used system time discovery techniques, which attackers may use during the reconnaissance
phase after compromising a system.
**Rule type**: eql
**Rule indices**:
- endgame-*
- logs-endpoint.events.process-*
- logs-system.security*
- logs-windows.*
- winlogbeat-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Discovery
- Data Source: Elastic Defend
- Data Source: Elastic Endgame
- Rule Type: BBR
- Data Source: Windows Security Event Logs

**Version**: 113
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```eql
process where host.os.type == "windows" and event.type == "start" and
(
 (
    (process.name: "net.exe" or (process.name : "net1.exe" and not process.parent.name : "net.exe")) and 
    process.args : "time" and not process.args : "/set"
 ) or 
 (process.name: "w32tm.exe" and process.args: "/tz") or 
 (process.name: "tzutil.exe" and process.args: "/g")
) and not user.id : ("S-1-5-18", "S-1-5-19", "S-1-5-20")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: System Time Discovery
- Id: T1124
- Reference URL: [[https://attack.mitre.org/techniques/T1124/](https://attack.mitre.org/techniques/T1124/)](https://attack.mitre.org/techniques/T1124/)