﻿---
title: System Service Discovery through built-in Windows Utilities
description: Detects the usage of commonly used system service discovery techniques, which attackers may use during the reconnaissance phase after compromising a system...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_system_service_discovery
products:
  - Elastic Security
---

# System Service Discovery through built-in Windows Utilities
Detects the usage of commonly used system service discovery techniques, which attackers may use during the
reconnaissance phase after compromising a system in order to gain a better understanding of the environment and/or
escalate privileges.
**Rule type**: eql
**Rule indices**:
- endgame-*
- logs-endpoint.events.process-*
- logs-system.security*
- logs-windows.*
- winlogbeat-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Discovery
- Data Source: Elastic Defend
- Data Source: Elastic Endgame
- Rule Type: BBR
- Data Source: Windows Security Event Logs

**Version**: 113
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```eql
process where host.os.type == "windows" and event.type == "start" and process.parent.executable != null and
  (
  ((process.name: "net.exe" or process.pe.original_file_name == "net.exe" or (process.name : "net1.exe" and 
    not process.parent.name : "net.exe")) and process.args : ("start", "use") and process.args_count == 2 and
    not process.parent.args : ("*.bat", "*netlogon*", "\\\\*")) or
  ((process.name: "sc.exe" or process.pe.original_file_name == "sc.exe") and process.args: ("query", "q*") and not process.parent.args : "*.bat") or
  ((process.name: "tasklist.exe" or process.pe.original_file_name == "tasklist.exe") and process.args: "/svc" and not process.command_line : "*\\Windows\\TEMP\\nessus_task_list*") or
  (process.name : "psservice.exe" or process.pe.original_file_name == "psservice.exe")
  ) and
  not user.id in ("S-1-5-18", "S-1-5-19", "S-1-5-20") and
  not process.parent.executable in
                       ("C:\\Program Files\\AzureConnectedMachineAgent\\himds.exe",
                        "C:\\Program Files\\AzureConnectedMachineAgent\\azcmagent.exe",
                        "C:\\Program Files\\Varian\\DICOMServices\\VMS.DICOMServices.ServiceFW.GenericControlledServiceHost.exe",
                        "C:\\Senior\\HCM\\jdk-11.0.2\\bin\\java.exe",
                        "D:\\biomerieux\\programs\\ServiceMonitor\\bin\\MylaServiceMonitor.exe",
                        "C:\\ViewPowerPro\\openJDK\\bin\\javaw.exe",
                        "C:\\ServiceNow MID Server mid-server-autosports-prod\\agent\\jre\\bin\\java.exe") and
  not process.command_line in ("sc  queryex SCardSvr",
                               "sc  query \"Axway_Integrator\" ",
                               "sc  query \"Delta enteliVAULT PostgreSQL\" ",
                               "sc  query \"WERMA-WIN-Connector\" ",
                               "sc  query _EWSSynchronizationServer_JDE ",
                               "sc query SchneiderUPSMySQL")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: System Service Discovery
- Id: T1007
- Reference URL: [[https://attack.mitre.org/techniques/T1007/](https://attack.mitre.org/techniques/T1007/)](https://attack.mitre.org/techniques/T1007/)