﻿---
title: System Network Connections Discovery
description: Adversaries may attempt to get a listing of network connections to or from a compromised system. Rule type: new_terms Rule indices: logs-endpoint.events.*...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_system_network_connections
products:
  - Elastic Security
---

# System Network Connections Discovery
Adversaries may attempt to get a listing of network connections to or from a compromised system.
**Rule type**: new_terms
**Rule indices**:
- logs-endpoint.events.*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 60m
**Searches indices from**: `now-119m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Linux
- OS: macOS
- Use Case: Threat Detection
- Tactic: Discovery
- Rule Type: BBR
- Data Source: Elastic Defend

**Version**: 6
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```kuery
event.category:process and host.os.type:(linux or macos) and event.type:start and event.action:exec and
process.name:("netstat" or "lsof" or "ss" or "iftop" or "ip" or "nmcli" or "arp" or "route" or "ifconfig" or "netcfg" or "networksetup") and
not (
  process.parent.executable:(
    /Library/Elastic/Agent/* or "/Applications/Docker.app/Contents/MacOS/com.docker.backend" or
    "/opt/NinjaRMMAgent/programfiles/ninjarmm-linagent" or "/usr/local/ASR/Vx/bin/svagents"
  ) or
  process.working_directory:("/var/ossec" or "/usr/lib/check_mk_agent/plugins" or "/opt/microsoft/mdatp/sbin")
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: System Network Connections Discovery
- Id: T1049
- Reference URL: [[https://attack.mitre.org/techniques/T1049/](https://attack.mitre.org/techniques/T1049/)](https://attack.mitre.org/techniques/T1049/)