﻿---
title: Security Software Discovery using WMIC
description: Identifies the use of Windows Management Instrumentation Command (WMIC) to discover certain System Security Settings such as AntiVirus or Host Firewall...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_security_software_wmic
products:
  - Elastic Security
---

# Security Software Discovery using WMIC
Identifies the use of Windows Management Instrumentation Command (WMIC) to discover certain System Security Settings
such as AntiVirus or Host Firewall details.
**Rule type**: eql
**Rule indices**:
- endgame-*
- logs-endpoint.events.process-*
- logs-system.security*
- logs-windows.*
- winlogbeat-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Discovery
- Resources: Investigation Guide
- Data Source: Elastic Endgame
- Data Source: Elastic Defend
- Rule Type: BBR
- Data Source: Windows Security Event Logs

**Version**: 217
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Security Software Discovery using WMIC

After successfully compromising an environment, attackers may try to gain situational awareness to plan their next steps. This can happen by running commands to enumerate network resources, users, connections, files, and installed security software.
This rule looks for the execution of the `wmic` utility with arguments compatible to the enumeration of the security software installed on the host. Attackers can use this information to decide whether or not to infect a system, disable protections, use bypasses, etc.

#### Possible investigation steps

- Investigate the process execution chain (parent process tree) for unknown processes. Examine their executable files for prevalence, whether they are located in expected locations, and if they are signed with valid digital signatures.
- Identify the user account that performed the action and whether it should perform this kind of action.
- Investigate other alerts associated with the user/host during the past 48 hours.
- Investigate any abnormal account behavior, such as command executions, file creations or modifications, and network connections.


### False positive analysis

- Discovery activities are not inherently malicious if they occur in isolation. As long as the analyst did not identify suspicious activity related to the user or host, such alerts can be dismissed.


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- Isolate the involved hosts to prevent further post-compromise behavior.
- Investigate credential exposure on systems compromised or used by the attacker to ensure all compromised accounts are identified. Reset passwords for these accounts and other potentially compromised credentials, such as email, business systems, and web services.
- Run a full antimalware scan. This may reveal additional artifacts left in the system, persistence mechanisms, and malware components.
- Determine the initial vector abused by the attacker and take action to prevent reinfection through the same vector.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```eql
process where host.os.type == "windows" and event.type == "start" and
(process.name : "wmic.exe" or ?process.pe.original_file_name : "wmic.exe") and
process.args : "/namespace:\\\\root\\SecurityCenter2" and process.args : "Get"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: Software Discovery
- Id: T1518
- Reference URL: [[https://attack.mitre.org/techniques/T1518/](https://attack.mitre.org/techniques/T1518/)](https://attack.mitre.org/techniques/T1518/)
- Sub Technique:
  - Name: Security Software Discovery
- Id: T1518.001
- Reference URL: [[https://attack.mitre.org/techniques/T1518/001/](https://attack.mitre.org/techniques/T1518/001/)](https://attack.mitre.org/techniques/T1518/001/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Windows Management Instrumentation
- Id: T1047
- Reference URL: [[https://attack.mitre.org/techniques/T1047/](https://attack.mitre.org/techniques/T1047/)](https://attack.mitre.org/techniques/T1047/)