﻿---
title: Process Discovery via Built-In Applications
description: Identifies the use of built-in tools attackers can use to discover running processes on an endpoint. Rule type: new_terms Rule indices: logs-endpoint.events.*,...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_process_discovery_via_builtin_tools
products:
  - Elastic Security
---

# Process Discovery via Built-In Applications
Identifies the use of built-in tools attackers can use to discover running processes on an endpoint.
**Rule type**: new_terms
**Rule indices**:
- logs-endpoint.events.*
- endgame-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 60m
**Searches indices from**: `now-119m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Linux
- OS: macOS
- Use Case: Threat Detection
- Tactic: Discovery
- Rule Type: BBR
- Data Source: Elastic Defend
- Data Source: Elastic Endgame

**Version**: 6
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```kuery
event.category:process and host.os.type:(linux or macos) and event.type:start and event.action:(exec or exec_event) and
process.name:("ps" or "pstree" or "htop" or "pgrep") and not (
  process.parent.name:("amazon-ssm-agent" or "snap") or
  process.parent.args:("/usr/local/ASR/Vx/bin/status" or "/usr/sbin/ksmtuned") or
  process.parent.executable:(
    "/usr/bin/check_mk_agent" or /opt/gitlab/* or "/usr/bin/pmlogctl" or "/usr/libexec/pcp/bin/pmlogger_daily" or
    "/usr/libexec/pcp/bin/pmlogger_check"
  )
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: Process Discovery
- Id: T1057
- Reference URL: [[https://attack.mitre.org/techniques/T1057/](https://attack.mitre.org/techniques/T1057/)](https://attack.mitre.org/techniques/T1057/)
- Technique:
  - Name: Software Discovery
- Id: T1518
- Reference URL: [[https://attack.mitre.org/techniques/T1518/](https://attack.mitre.org/techniques/T1518/)](https://attack.mitre.org/techniques/T1518/)
- Sub Technique:
  - Name: Security Software Discovery
- Id: T1518.001
- Reference URL: [[https://attack.mitre.org/techniques/T1518/001/](https://attack.mitre.org/techniques/T1518/001/)](https://attack.mitre.org/techniques/T1518/001/)