﻿---
title: Potential Memory Seeking Activity
description: Monitors for the execution of Unix utilities that may be leveraged as memory address seekers. Attackers may leverage built-in utilities to seek specific...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_potential_memory_seeking_activity
products:
  - Elastic Security
---

# Potential Memory Seeking Activity
Monitors for the execution of Unix utilities that may be leveraged as memory address seekers. Attackers may leverage
built-in utilities to seek specific memory addresses, allowing for potential future manipulation/exploitation.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.*
- endgame-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://github.com/arget13/DDexec](https://github.com/arget13/DDexec)](https://github.com/arget13/DDexec)

**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Discovery
- Rule Type: BBR
- Data Source: Elastic Defend
- Data Source: Elastic Endgame

**Version**: 6
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```eql
process where host.os.type == "linux" and event.type == "start" and event.action in ("exec", "exec_event") and (
  (process.name == "tail" and process.args in ("-c", "--bytes")) or
  (process.name == "cmp" and process.args == "-i") or
  (process.name in ("hexdump", "xxd") and process.args == "-s") or
  (process.name == "dd" and process.args : ("skip*", "seek*"))
) and not (
  process.parent.args like ("/opt/error_monitor/error_monitor.sh", "printf*", "/sbin/dracut") or
  process.parent.name in ("acme.sh", "dracut", "leapp") or
  process.parent.executable like (
    "/bin/cagefs_enter", "/opt/nessus_agent/sbin/nessus-service", "/usr/libexec/platform-python*",
    "/usr/libexec/vdsm/vdsmd", "/usr/local/bin/docker-entrypoint.sh", "/usr/lib/module-init-tools/lsinitrd-quick",
    "/usr/bin/unmkinitramfs", "/usr/bin/lsinitramfs", "/opt/msp-agent/msp-agent-core.run",
    "/usr/local/cloudamize/bin/register.sh", "/usr/local/hestia/bin/v-log-action", "/usr/local/emps/bin/php"
  ) or
  process.parent.command_line like "sh*acme.sh*" or
  process.args like ("/var/tmp/dracut*", "/opt/bitdefender-security-tools/var/log/script_update.log") or
  ?process.working_directory like (
    "/usr/local/nutanix/ngt/python/bin", "/var/lib/waagent/*", "/opt/Tychon/Endpoint/bin",
    "/usr/local/cloudamize/bin", "/opt/sentinelone/bin"
  ) or
  process.command_line in ("tail -c 1", "tail -c 2") or
  (process.command_line == "dd ibs=18850 skip=1 count=1" and process.parent.args == "/opt/msp-agent/msp-agent-core.run")
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: Process Discovery
- Id: T1057
- Reference URL: [[https://attack.mitre.org/techniques/T1057/](https://attack.mitre.org/techniques/T1057/)](https://attack.mitre.org/techniques/T1057/)