﻿---
title: Account or Group Discovery via Built-In Tools
description: Adversaries may use built-in applications to get a listing of local system or domain accounts and groups. Rule type: new_terms Rule indices: logs-endpoint.events.*...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_of_accounts_or_groups_via_builtin_tools
products:
  - Elastic Security
---

# Account or Group Discovery via Built-In Tools
Adversaries may use built-in applications to get a listing of local system or domain accounts and groups.
**Rule type**: new_terms
**Rule indices**:
- logs-endpoint.events.*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 60m
**Searches indices from**: `now-119m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Linux
- OS: macOS
- Use Case: Threat Detection
- Tactic: Discovery
- Rule Type: BBR
- Data Source: Elastic Defend

**Version**: 6
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```kuery
event.category:process and host.os.type:(linux or macos) and event.action:exec and (
  (process.name:"dscl" and process.args:(/Active*Directory/* or /Users* or /Groups*)) or
  (process.name:"dscacheutil" and process.args:("user" or "group")) or
  (process.name:"getent" and process.args:("passwd" or "group") and process.args_count >= 3)
) and not (
  process.parent.executable:(
    "/usr/lib/ocf/resource.d/cyanconnode/mysql" or /snap/* or "/usr/bin/check_mk_agent" or "/usr/bin/cloudflared" or
    /opt/puppetlabs/* or /var/lib/snapd/* or "/usr/lib/google/guest_agent/core_plugin" or "/opt/rudder/bin/cf-agent" or
    "/opt/NinjaRMMAgent/programfiles/ninjarmm-linagent"
  ) or
  process.working_directory:(
    /var/snap/* or  "/Applications/NinjaRMMAgent/programfiles/ninjarmm-macagent" or "/var/lib/nanitor/agent" or
    "/var/ossec" or /opt/rapid7/* or "/opt/Tanium/TaniumClient"
  )
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: Permission Groups Discovery
- Id: T1069
- Reference URL: [[https://attack.mitre.org/techniques/T1069/](https://attack.mitre.org/techniques/T1069/)](https://attack.mitre.org/techniques/T1069/)
- Sub Technique:
  - Name: Local Groups
- Id: T1069.001
- Reference URL: [[https://attack.mitre.org/techniques/T1069/001/](https://attack.mitre.org/techniques/T1069/001/)](https://attack.mitre.org/techniques/T1069/001/)
- Sub Technique:
  - Name: Domain Groups
- Id: T1069.002
- Reference URL: [[https://attack.mitre.org/techniques/T1069/002/](https://attack.mitre.org/techniques/T1069/002/)](https://attack.mitre.org/techniques/T1069/002/)
- Technique:
  - Name: Account Discovery
- Id: T1087
- Reference URL: [[https://attack.mitre.org/techniques/T1087/](https://attack.mitre.org/techniques/T1087/)](https://attack.mitre.org/techniques/T1087/)
- Sub Technique:
  - Name: Local Account
- Id: T1087.001
- Reference URL: [[https://attack.mitre.org/techniques/T1087/001/](https://attack.mitre.org/techniques/T1087/001/)](https://attack.mitre.org/techniques/T1087/001/)
- Sub Technique:
  - Name: Domain Account
- Id: T1087.002
- Reference URL: [[https://attack.mitre.org/techniques/T1087/002/](https://attack.mitre.org/techniques/T1087/002/)](https://attack.mitre.org/techniques/T1087/002/)