﻿---
title: Potential Network Share Discovery
description: Adversaries may look for folders and drives shared on remote systems to identify sources of information to gather as a precursor for collection and identify...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_net_share_discovery_winlog
products:
  - Elastic Security
---

# Potential Network Share Discovery
Adversaries may look for folders and drives shared on remote systems to identify sources of information to gather as a
precursor for collection and identify potential systems of interest for Lateral Movement.
**Rule type**: eql
**Rule indices**:
- logs-system.security*
- logs-windows.*
- winlogbeat-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 60m
**Searches indices from**: `now-119m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Discovery
- Tactic: Collection
- Rule Type: BBR
- Data Source: Windows Security Event Logs

**Version**: 109
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```eql
sequence by user.name, source.port, source.ip with maxspan=15s 
 [file where event.action == "network-share-object-access-checked" and 
  winlog.event_data.ShareName in ("\\\\*\\ADMIN$", "\\\\*\\C$") and 
  source.ip != null and source.ip != "0.0.0.0" and source.ip != "::1" and source.ip != "::" and source.ip != "127.0.0.1"]
 [file where event.action == "network-share-object-access-checked" and 
  winlog.event_data.ShareName in ("\\\\*\\ADMIN$", "\\\\*\\C$") and 
  source.ip != null and source.ip != "0.0.0.0" and source.ip != "::1" and source.ip != "::" and source.ip != "127.0.0.1"]
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: Network Share Discovery
- Id: T1135
- Reference URL: [[https://attack.mitre.org/techniques/T1135/](https://attack.mitre.org/techniques/T1135/)](https://attack.mitre.org/techniques/T1135/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Collection
- Id: TA0009
- Reference URL: [[https://attack.mitre.org/tactics/TA0009/](https://attack.mitre.org/tactics/TA0009/)](https://attack.mitre.org/tactics/TA0009/)
- Technique:
  - Name: Data from Network Shared Drive
- Id: T1039
- Reference URL: [[https://attack.mitre.org/techniques/T1039/](https://attack.mitre.org/techniques/T1039/)](https://attack.mitre.org/techniques/T1039/)