﻿---
title: System Owner/User Discovery Linux
description: Identifies the use of built-in tools which adversaries may use to enumerate the system owner/user of a compromised system. Rule type: new_terms Rule indices:...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_linux_system_owner_user_discovery
products:
  - Elastic Security
---

# System Owner/User Discovery Linux
Identifies the use of built-in tools which adversaries may use to enumerate the system owner/user of a compromised
system.
**Rule type**: new_terms
**Rule indices**:
- logs-endpoint.events.*
- endgame-*
- logs-sentinel_one_cloud_funnel.*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 60m
**Searches indices from**: `now-119m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Discovery
- Rule Type: BBR
- Data Source: Elastic Defend
- Data Source: Elastic Endgame
- Data Source: SentinelOne

**Version**: 7
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```kuery
event.category:process and host.os.type:linux and event.type:start and event.action:(exec or exec_event or start) and
process.name:("whoami" or "w" or "who" or "users" or "id" or "groups")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: System Owner/User Discovery
- Id: T1033
- Reference URL: [[https://attack.mitre.org/techniques/T1033/](https://attack.mitre.org/techniques/T1033/)](https://attack.mitre.org/techniques/T1033/)
- Technique:
  - Name: Permission Groups Discovery
- Id: T1069
- Reference URL: [[https://attack.mitre.org/techniques/T1069/](https://attack.mitre.org/techniques/T1069/)](https://attack.mitre.org/techniques/T1069/)