﻿---
title: Linux System Information Discovery
description: This rule identifies Linux system information discovery activity via built-in commands that read common system files. Adversaries may use these commands...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_linux_system_information_discovery
products:
  - Elastic Security
---

# Linux System Information Discovery
This rule identifies Linux system information discovery activity via built-in commands that read common
system files. Adversaries may use these commands to gather information about the operating system, installed
services, and hardware configuration to aid in further exploration and exploitation of the system.
**Rule type**: new_terms
**Rule indices**:
- logs-endpoint.events.*
- endgame-*
- logs-sentinel_one_cloud_funnel.*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 60m
**Searches indices from**: `now-119m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Discovery
- Rule Type: BBR
- Data Source: Elastic Defend
- Data Source: Elastic Endgame
- Data Source: SentinelOne

**Version**: 7
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```kuery
event.category:process and host.os.type:linux and event.type:start and event.action:(exec or exec_event or start) and
process.name:("cat" or "more" or "less" or "nano" or "vi" or "vim" or "vim.basic" or "emacs") and
process.args:(
  "/etc/issue" or "/etc/os-release" or "/proc/version" or "/etc/profile" or "/proc/cpuinfo" or "/etc/services" or
  "/etc/lsb-release" or "/etc/redhat-release" or "/etc/debian_version" or "/etc/hostname"
) and
not process.parent.executable:("/usr/local/jamf/bin/jamf" or "/etc/cp/watchdog/cp-nano-watchdog")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: System Information Discovery
- Id: T1082
- Reference URL: [[https://attack.mitre.org/techniques/T1082/](https://attack.mitre.org/techniques/T1082/)](https://attack.mitre.org/techniques/T1082/)