﻿---
title: Kubectl Workload and Cluster Discovery
description: This rule detects the execution of kubectl commands that are commonly used for workload and cluster discovery in Kubernetes environments. It looks for...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_kubectl_workload_and_cluster_discovery
products:
  - Elastic Security
---

# Kubectl Workload and Cluster Discovery
This rule detects the execution of kubectl commands that are commonly used for workload and cluster
discovery in Kubernetes environments. It looks for process events where kubectl is executed with
arguments that query cluster information, such as namespaces, nodes, pods, deployments, and other
resources. In environments where kubectl is not expected to be used, this could indicate potential
reconnaissance activity by an adversary.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.*
- endgame-*
- auditbeat-*
- logs-auditd_manager.auditd-*
- logs-crowdstrike.fdr*
- logs-cloud_defend.process*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 60m
**Searches indices from**: `now-119m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Container
- Domain: Endpoint
- Domain: Kubernetes
- OS: Linux
- Use Case: Threat Detection
- Tactic: Discovery
- Rule Type: BBR
- Data Source: Elastic Defend
- Data Source: Elastic Endgame
- Data Source: Auditd Manager
- Data Source: Crowdstrike
- Data Source: Elastic Defend for Containers

**Version**: 102
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```eql
process where host.os.type == "linux" and event.type == "start" and
event.action in ("exec", "exec_event", "executed", "process_started", "ProcessRollup2") and
process.name == "kubectl" and (
  (process.args in ("cluster-info", "api-resources", "api-versions", "version")) or
  (process.args in ("get", "describe") and process.args in (
    "namespaces", "nodes", "pods", "pod", "deployments", "deployment",
    "replicasets", "statefulsets", "daemonsets", "services", "service",
    "ingress", "ingresses", "endpoints", "configmaps", "events", "svc",
    "roles", "rolebindings", "clusterroles", "clusterrolebindings"
    )
  )
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: Container and Resource Discovery
- Id: T1613
- Reference URL: [[https://attack.mitre.org/techniques/T1613/](https://attack.mitre.org/techniques/T1613/)](https://attack.mitre.org/techniques/T1613/)
- Technique:
  - Name: Permission Groups Discovery
- Id: T1069
- Reference URL: [[https://attack.mitre.org/techniques/T1069/](https://attack.mitre.org/techniques/T1069/)](https://attack.mitre.org/techniques/T1069/)