﻿---
title: Kubectl Configuration Discovery
description: This rule detects the execution of kubectl commands that are commonly used for configuration discovery in Kubernetes environments. It looks for process...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_kubectl_configuration_discovery
products:
  - Elastic Security
---

# Kubectl Configuration Discovery
This rule detects the execution of kubectl commands that are commonly used for configuration discovery in Kubernetes
environments. It looks for process events where kubectl is executed with arguments that query configuration information,
such as configmaps. In environments where kubectl is not expected to be used, this could indicate potential reconnaissance
activity by an adversary.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.*
- endgame-*
- auditbeat-*
- logs-auditd_manager.auditd-*
- logs-crowdstrike.fdr*
- logs-cloud_defend.process*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 60m
**Searches indices from**: `now-119m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Container
- Domain: Endpoint
- Domain: Kubernetes
- OS: Linux
- Use Case: Threat Detection
- Tactic: Discovery
- Rule Type: BBR
- Data Source: Elastic Defend
- Data Source: Elastic Endgame
- Data Source: Auditd Manager
- Data Source: Crowdstrike
- Data Source: Elastic Defend for Containers

**Version**: 103
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```eql
process where host.os.type == "linux" and event.type == "start" and
event.action in ("exec", "exec_event", "executed", "process_started", "ProcessRollup2") and
process.name == "kubectl" and process.args in ("get", "describe") and process.args in ("configmap", "configmaps") and
not ?process.parent.args in (
  "/hooks/schedule_sync_configmap.sh", "/service-fabric/generate-support-bundle.sh", "/hooks/onstartup_sync_configmap.sh"
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: Container and Resource Discovery
- Id: T1613
- Reference URL: [[https://attack.mitre.org/techniques/T1613/](https://attack.mitre.org/techniques/T1613/)](https://attack.mitre.org/techniques/T1613/)