﻿---
title: Enumeration of Kernel Modules via Proc
description: Loadable Kernel Modules (or LKMs) are pieces of code that can be loaded and unloaded into the kernel upon demand. They extend the functionality of the...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_kernel_module_enumeration_via_proc
products:
  - Elastic Security
---

# Enumeration of Kernel Modules via Proc
Loadable Kernel Modules (or LKMs) are pieces of code that can be loaded and unloaded into the kernel upon demand. They
extend the functionality of the kernel without the need to reboot the system. This identifies attempts to enumerate
information about a kernel module using the /proc/modules filesystem. This filesystem is used by utilities such as lsmod
and kmod to list the available kernel modules.
**Rule type**: new_terms
**Rule indices**:
- auditbeat-*
- logs-auditd_manager.auditd-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 60m
**Searches indices from**: `now-119m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Data Source: Auditd Manager
- OS: Linux
- Use Case: Threat Detection
- Tactic: Discovery
- Rule Type: BBR

**Version**: 110
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires the use of the `auditd_manager` integration. `Auditd_manager` is a tool designed to simplify and enhance the management of the audit subsystem in Linux systems. It provides a user-friendly interface and automation capabilities for configuring and monitoring system auditing through the auditd daemon. With `auditd_manager`, administrators can easily define audit rules, track system events, and generate comprehensive audit reports, improving overall security and compliance in the system. The following steps should be executed in order to install and deploy `auditd_manager` on a Linux system.
```
Kibana -->
Management -->
Integrations -->
Auditd Manager -->
Add Auditd Manager
```

`Auditd_manager` subscribes to the kernel and receives events as they occur without any additional configuration. However, if more advanced configuration is required to detect specific behavior, audit rules can be added to the integration in either the "audit rules" configuration box or the "auditd rule files" box by specifying a file to read the audit rules from.
For this detection rule to trigger, the following additional audit rules are required to be added to the integration:
```
-w /proc/ -p r -k audit_proc
```

Add the newly installed `auditd manager` to an agent policy, and deploy the agent on a Linux system from which auditd log files are desirable.

## Rule Query

```kuery
host.os.type:linux and event.category:file and event.action:"opened-file" and file.path:"/proc/modules" and
not (
  process.name:(python* or chef-client) or
  process.executable:(/opt/eset/*/esets_eia or /opt/Elastic/Agent/* or "/opt/jfrog/artifactory/app/metadata/bin/jf-metadata")
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: System Information Discovery
- Id: T1082
- Reference URL: [[https://attack.mitre.org/techniques/T1082/](https://attack.mitre.org/techniques/T1082/)](https://attack.mitre.org/techniques/T1082/)