﻿---
title: Discovery of Internet Capabilities via Built-in Tools
description: Identifies the use of built-in tools attackers can use to check for Internet connectivity on compromised systems. These results may be used to determine...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_internet_capabilities
products:
  - Elastic Security
---

# Discovery of Internet Capabilities via Built-in Tools
Identifies the use of built-in tools attackers can use to check for Internet connectivity on compromised systems. These
results may be used to determine communication capabilities with C2 servers, or to identify routes, redirectors, and
proxy servers.
**Rule type**: new_terms
**Rule indices**:
- logs-endpoint.events.*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Discovery
- Rule Type: BBR
- Data Source: Elastic Defend

**Version**: 104
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```kuery
host.os.type:windows and event.category:process and event.type:start and 
process.name.caseless:("ping.exe" or "tracert.exe" or "pathping.exe") and
not process.args:("127.0.0.1" or "0.0.0.0" or "localhost" or "::1")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: System Network Configuration Discovery
- Id: T1016
- Reference URL: [[https://attack.mitre.org/techniques/T1016/](https://attack.mitre.org/techniques/T1016/)](https://attack.mitre.org/techniques/T1016/)
- Sub Technique:
  - Name: Internet Connection Discovery
- Id: T1016.001
- Reference URL: [[https://attack.mitre.org/techniques/T1016/001/](https://attack.mitre.org/techniques/T1016/001/)](https://attack.mitre.org/techniques/T1016/001/)