﻿---
title: System Hosts File Access
description: Identifies the use of built-in tools to read the contents of "/etc/hosts" on a local machine. Attackers may use this data to discover remote machines...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_hosts_file_access
products:
  - Elastic Security
---

# System Hosts File Access
Identifies the use of built-in tools to read the contents of "/etc/hosts" on a local machine. Attackers may use this data
to discover remote machines in an environment that may be used for Lateral Movement from the current system.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.*
- endgame-*
- auditbeat-*
- logs-auditd_manager.auditd-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 60m
**Searches indices from**: `now-119m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Linux
- OS: macOS
- Use Case: Threat Detection
- Tactic: Discovery
- Rule Type: BBR
- Data Source: Elastic Defend
- Data Source: Elastic Endgame
- Data Source: Auditd Manager

**Version**: 6
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```eql
process where event.type == "start" and event.action in ("exec", "exec_event", "executed", "process_started") and
process.name in ("vi", "nano", "cat", "more", "less", "vim", "vim.basic", "emacs") and process.args == "/etc/hosts" and
not ?process.working_directory in ("/opt/SolarWinds/Agent/bin/Plugins/SCM", "/opt/cohesityagent/software/crux/bin")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: Remote System Discovery
- Id: T1018
- Reference URL: [[https://attack.mitre.org/techniques/T1018/](https://attack.mitre.org/techniques/T1018/)](https://attack.mitre.org/techniques/T1018/)