﻿---
title: Linux System Information Discovery via Getconf
description: This rule identifies Linux system information discovery via the "getconf" command. The "getconf" command is used to query system configuration variables...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_getconf_execution
products:
  - Elastic Security
---

# Linux System Information Discovery via Getconf
This rule identifies Linux system information discovery via the "getconf" command. The "getconf" command is used to query system configuration
variables and system limits. Adversaries may use this command to gather information about the system, such as the page size, maximum number
of open files, and other system limits, to aid in further exploration and exploitation of the system.
**Rule type**: new_terms
**Rule indices**:
- logs-endpoint.events.process*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 60m
**Searches indices from**: `now-119m`
**Maximum alerts per execution**: 100
**References**:
- [[https://blog.exatrack.com/Perfctl-using-portainer-and-new-persistences/](https://blog.exatrack.com/Perfctl-using-portainer-and-new-persistences/)](https://blog.exatrack.com/Perfctl-using-portainer-and-new-persistences/)

**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Discovery
- Rule Type: BBR
- Data Source: Elastic Defend

**Version**: 5
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```kuery
event.category:process and host.os.type:linux and event.type:start and event.action:exec and process.name:getconf and not (
  process.parent.executable:(
    "/usr/bin/google_guest_agent_manager" or "/opt/commvault/Base64/cvlaunchd" or /usr/local/manageengine/uems_agent/bin/*
  ) or
  process.working_directory:(
    "/opt/oracle/mgmt_agent/agent_inst/bin" or "/var/lib/oracle-cloud-agent/plugins/oci-managementagent/polaris" or
    "/opt/commvault/Base/cvlaunchd" or "/opt/simpana" or "/opt/commvault" or "/opt/ITSPlatform/agentcore" or
    "/u01/app/oracle/EMBase/agent_inst/sysman/emd" or "/opt/abacus/lib"
  ) or
  process.parent.args:(
    /opt/oracle/mgmt_agent/agent_inst/* or "/opt/datadog-agent/bin/agent/agent" or "/usr/bin/byobu-status" or
    "/usr/local/nagios/libexec/check_ssl_cert" or "/usr/lib64/nagios/plugins/cpanel/check_ssl_cert"
  ) or
  process.parent.command_line:(
    "/bin/sh -s unix:cmd" or "ruby /usr/local/bundle/bin/bundle exec rackup"
  )
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: System Information Discovery
- Id: T1082
- Reference URL: [[https://attack.mitre.org/techniques/T1082/](https://attack.mitre.org/techniques/T1082/)](https://attack.mitre.org/techniques/T1082/)