﻿---
title: Query Registry using Built-in Tools
description: This rule identifies the execution of commands that can be used to query the Windows Registry. Adversaries may query the registry to gain situational...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_generic_registry_query
products:
  - Elastic Security
---

# Query Registry using Built-in Tools
This rule identifies the execution of commands that can be used to query the Windows Registry. Adversaries may query the
registry to gain situational awareness about the host, like installed security software, programs and settings.
**Rule type**: new_terms
**Rule indices**:
- logs-endpoint.events.process-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 12h
**Searches indices from**: `now-24h`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Discovery
- Rule Type: BBR
- Data Source: Elastic Defend

**Version**: 108
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```kuery
host.os.type:windows and event.category:process and event.type:start and
  (
    (process.name.caseless:"reg.exe" and process.args:"query") or
    (process.name.caseless:("powershell.exe" or "powershell_ise.exe" or "pwsh.exe") and
     process.args:(
       ("get-childitem" or "Get-ChildItem" or "gci" or "dir" or "ls" or
        "get-item" or "Get-Item" or "gi" or
        "get-itemproperty" or "Get-ItemProperty" or "gp") and
       ("hkcu" or "HKCU" or "hkey_current_user" or "HKEY_CURRENT_USER" or
        "hkey_local_machine" or "HKEY_LOCAL_MACHINE" or
        "hklm" or "HKLM" or registry\:\:*)
      )
    )
  ) and
  not process.command_line : (
    "C:\\Windows\\system32\\reg.exe  query hklm\\software\\microsoft\\windows\\softwareinventorylogging /v collectionstate /reg:64" or
    "reg  query \"HKLM\\Software\\WOW6432Node\\Npcap\" /ve  "
  )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: Query Registry
- Id: T1012
- Reference URL: [[https://attack.mitre.org/techniques/T1012/](https://attack.mitre.org/techniques/T1012/)](https://attack.mitre.org/techniques/T1012/)