﻿---
title: Process Discovery Using Built-in Tools
description: This rule identifies the execution of commands that can be used to enumerate running processes. Adversaries may enumerate processes to identify installed...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_generic_process_discovery
products:
  - Elastic Security
---

# Process Discovery Using Built-in Tools
This rule identifies the execution of commands that can be used to enumerate running processes. Adversaries may
enumerate processes to identify installed applications and security solutions.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.process-*
- logs-system.security*
- logs-windows.*
- winlogbeat-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Discovery
- Rule Type: BBR
- Data Source: Elastic Defend
- Data Source: Windows Security Event Logs

**Version**: 111
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```eql
process where host.os.type == "windows" and event.type == "start" and process.args != null and 
  not user.id in ("S-1-5-18", "S-1-5-19", "S-1-5-20") and process.parent.executable != null and
  (
   process.name :("PsList.exe", "qprocess.exe") or

   (process.name : "powershell.exe" and process.args : ("*get-process*", "*Win32_Process*") and not process.parent.name in ("openaev-agent.exe", "cmd.exe", "Miro.exe", "Granola.exe", "Wispr Flow.exe")) or

   (process.name : "wmic.exe" and process.args : ("process", "*Win32_Process*") and not process.parent.name in ("Code.exe", "node.exe", "javaw.exe", "java.exe", "asus_framework.exe", "Evernote.exe", "RingCentral.exe", "Avaya Cloud.exe", "Arduino IDE.exe")) or

   (process.name : "tasklist.exe" and process.args_count == 1 and process.parent.args != "tasklist | findstr consent.exe") or

   (process.name : "query.exe" and process.args : ("process", "imagename*", "csv", "/fi"))
  ) and
  not process.working_directory like ("?:\\Program Files*", "D:\\*", "E:\\*") and
  not process.parent.executable like ("?:\\Program Files (x86)\\*.exe", "?:\\Program Files\\*.exe")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: Process Discovery
- Id: T1057
- Reference URL: [[https://attack.mitre.org/techniques/T1057/](https://attack.mitre.org/techniques/T1057/)](https://attack.mitre.org/techniques/T1057/)