﻿---
title: Windows Account or Group Discovery
description: This rule identifies the execution of commands that enumerates account or group information. Adversaries may use built-in applications to get a listing...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_generic_account_groups
products:
  - Elastic Security
---

# Windows Account or Group Discovery
This rule identifies the execution of commands that enumerates account or group information. Adversaries may use
built-in applications to get a listing of local system or domain accounts and groups.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.process-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Discovery
- Rule Type: BBR
- Data Source: Elastic Defend

**Version**: 7
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```eql
process where host.os.type == "windows" and event.type == "start" and
(
  (
   (
    (process.name : "net.exe" or process.pe.original_file_name == "net.exe") or
    (
     (process.name : "net1.exe" or process.pe.original_file_name == "net1.exe") and
     not process.parent.name : "net.exe"
    )
   ) and process.args : ("accounts", "group", "user", "localgroup") and not process.args : "/add"
  ) or
  (process.name:("dsquery.exe", "dsget.exe") and process.args:("*members*", "user")) or
  (process.name:"dsquery.exe" and process.args:"*filter*") or
  process.name:("quser.exe", "qwinsta.exe", "PsGetSID.exe", "PsLoggedOn.exe", "LogonSessions.exe", "whoami.exe") or
  (
    process.name: "cmd.exe" and
    (
      process.args : "echo" and process.args : (
        "%username%", "%userdomain%", "%userdnsdomain%",
        "%userdomain_roamingprofile%", "%userprofile%",
        "%homepath%", "%localappdata%", "%appdata%"
      ) or
      process.args : "set"
    )
  )
) and not process.parent.args: "C:\\Program Files (x86)\\Microsoft Intune Management Extension\\Content\\DetectionScripts\\*.ps1"
and not process.parent.name : "LTSVC.exe" and not user.id : "S-1-5-18"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: Permission Groups Discovery
- Id: T1069
- Reference URL: [[https://attack.mitre.org/techniques/T1069/](https://attack.mitre.org/techniques/T1069/)](https://attack.mitre.org/techniques/T1069/)
- Sub Technique:
  - Name: Local Groups
- Id: T1069.001
- Reference URL: [[https://attack.mitre.org/techniques/T1069/001/](https://attack.mitre.org/techniques/T1069/001/)](https://attack.mitre.org/techniques/T1069/001/)
- Sub Technique:
  - Name: Domain Groups
- Id: T1069.002
- Reference URL: [[https://attack.mitre.org/techniques/T1069/002/](https://attack.mitre.org/techniques/T1069/002/)](https://attack.mitre.org/techniques/T1069/002/)
- Technique:
  - Name: Account Discovery
- Id: T1087
- Reference URL: [[https://attack.mitre.org/techniques/T1087/](https://attack.mitre.org/techniques/T1087/)](https://attack.mitre.org/techniques/T1087/)
- Sub Technique:
  - Name: Local Account
- Id: T1087.001
- Reference URL: [[https://attack.mitre.org/techniques/T1087/001/](https://attack.mitre.org/techniques/T1087/001/)](https://attack.mitre.org/techniques/T1087/001/)
- Sub Technique:
  - Name: Domain Account
- Id: T1087.002
- Reference URL: [[https://attack.mitre.org/techniques/T1087/002/](https://attack.mitre.org/techniques/T1087/002/)](https://attack.mitre.org/techniques/T1087/002/)
- Technique:
  - Name: Password Policy Discovery
- Id: T1201
- Reference URL: [[https://attack.mitre.org/techniques/T1201/](https://attack.mitre.org/techniques/T1201/)](https://attack.mitre.org/techniques/T1201/)