﻿---
title: WRITEDAC Access on Active Directory Object
description: Identifies the access on an object with WRITEDAC permissions. With the WRITEDAC permission, the user can perform a Write Discretionary Access Control...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_write_dac_access
products:
  - Elastic Security
---

# WRITEDAC Access on Active Directory Object
Identifies the access on an object with WRITEDAC permissions. With the WRITEDAC permission, the user can perform a Write
Discretionary Access Control List (WriteDACL) operation, which is used to modify the access control rules associated
with a specific object within Active Directory. Attackers may abuse this privilege to grant themselves or other
compromised accounts additional rights, ultimately compromising the target object, resulting in privilege escalation,
lateral movement, and persistence.
**Rule type**: query
**Rule indices**:
- winlogbeat-*
- logs-system.security*
- logs-windows.*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 60m
**Searches indices from**: `now-119m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.blackhat.com/docs/us-17/wednesday/us-17-Robbins-An-ACE-Up-The-Sleeve-Designing-Active-Directory-DACL-Backdoors.pdf](https://www.blackhat.com/docs/us-17/wednesday/us-17-Robbins-An-ACE-Up-The-Sleeve-Designing-Active-Directory-DACL-Backdoors.pdf)](https://www.blackhat.com/docs/us-17/wednesday/us-17-Robbins-An-ACE-Up-The-Sleeve-Designing-Active-Directory-DACL-Backdoors.pdf)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Data Source: Active Directory
- Use Case: Active Directory Monitoring
- Rule Type: BBR
- Data Source: Windows Security Event Logs

**Version**: 110
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

The 'Audit Directory Service Access' logging policy must be configured for (Success, Failure).
Steps to implement the logging policy with Advanced Audit Configuration:
```
Computer Configuration >
Policies >
Windows Settings >
Security Settings >
Advanced Audit Policies Configuration >
Audit Policies >
DS Access >
Audit Directory Service Access (Success,Failure)
```


## Rule Query

```kuery
host.os.type: "windows" and event.action : ("Directory Service Access" or "object-operation-performed") and
  event.code : "4662" and winlog.event_data.AccessMask:"0x40000"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: File and Directory Permissions Modification
- Id: T1222
- Reference URL: [[https://attack.mitre.org/techniques/T1222/](https://attack.mitre.org/techniques/T1222/)](https://attack.mitre.org/techniques/T1222/)
- Sub Technique:
  - Name: Windows File and Directory Permissions Modification
- Id: T1222.001
- Reference URL: [[https://attack.mitre.org/techniques/T1222/001/](https://attack.mitre.org/techniques/T1222/001/)](https://attack.mitre.org/techniques/T1222/001/)