﻿---
title: Unsigned BITS Service Client Process
description: Identifies an unsigned Windows Background Intelligent Transfer Service (BITS) client process. Attackers may abuse BITS functionality to download or upload...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_unsigned_bits_client
products:
  - Elastic Security
---

# Unsigned BITS Service Client Process
Identifies an unsigned Windows Background Intelligent Transfer Service (BITS) client process. Attackers may abuse BITS
functionality to download or upload data using the BITS service.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.library-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 60m
**Searches indices from**: `now-119m`
**Maximum alerts per execution**: 100
**References**:
- [[https://web.archive.org/web/20230531215706/https://blog.menasec.net/2021/05/hunting-for-suspicious-usage-of.html](https://web.archive.org/web/20230531215706/https://blog.menasec.net/2021/05/hunting-for-suspicious-usage-of.html)](https://web.archive.org/web/20230531215706/https://blog.menasec.net/2021/05/hunting-for-suspicious-usage-of.html)
- [[https://www.elastic.co/blog/hunting-for-persistence-using-elastic-security-part-2](https://www.elastic.co/blog/hunting-for-persistence-using-elastic-security-part-2)](https://www.elastic.co/blog/hunting-for-persistence-using-elastic-security-part-2)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Rule Type: BBR
- Data Source: Elastic Defend

**Version**: 5
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```eql
library where dll.name : "Bitsproxy.dll" and process.executable != null and
not process.code_signature.trusted == true and
not process.code_signature.status : ("errorExpired", "errorCode_endpoint*")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Masquerading
- Id: T1036
- Reference URL: [[https://attack.mitre.org/techniques/T1036/](https://attack.mitre.org/techniques/T1036/)](https://attack.mitre.org/techniques/T1036/)
- Sub Technique:
  - Name: Invalid Code Signature
- Id: T1036.001
- Reference URL: [[https://attack.mitre.org/techniques/T1036/001/](https://attack.mitre.org/techniques/T1036/001/)](https://attack.mitre.org/techniques/T1036/001/)
- Technique:
  - Name: BITS Jobs
- Id: T1197
- Reference URL: [[https://attack.mitre.org/techniques/T1197/](https://attack.mitre.org/techniques/T1197/)](https://attack.mitre.org/techniques/T1197/)