﻿---
title: Service Disabled via Registry Modification
description: Identifies attempts to modify services start settings using processes other than services.exe. Attackers may attempt to modify security and monitoring...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_service_disabled_registry
products:
  - Elastic Security
---

# Service Disabled via Registry Modification
Identifies attempts to modify services start settings using processes other than services.exe. Attackers may attempt to
modify security and monitoring services to avoid detection or delay response.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.registry-*
- endgame-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 60m
**Searches indices from**: `now-119m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Data Source: Elastic Endgame
- Data Source: Elastic Defend
- Rule Type: BBR

**Version**: 5
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```eql
registry where host.os.type == "windows" and event.type == "change" and
  registry.path : (
    "HKLM\\SYSTEM\\*ControlSet*\\Services\\*\\Start",
    "\\REGISTRY\\MACHINE\\SYSTEM\\*ControlSet*\\Services\\*\\Start"
  ) and registry.data.strings : ("3", "4") and
  not 
    (
      process.name : "services.exe" and user.id : "S-1-5-18"
    )
  and not registry.path : "HKLM\\SYSTEM\\ControlSet001\\Services\\MrxSmb10\\Start"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Modify Registry
- Id: T1112
- Reference URL: [[https://attack.mitre.org/techniques/T1112/](https://attack.mitre.org/techniques/T1112/)](https://attack.mitre.org/techniques/T1112/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Impact
- Id: TA0040
- Reference URL: [[https://attack.mitre.org/tactics/TA0040/](https://attack.mitre.org/tactics/TA0040/)](https://attack.mitre.org/tactics/TA0040/)
- Technique:
  - Name: Service Stop
- Id: T1489
- Reference URL: [[https://attack.mitre.org/techniques/T1489/](https://attack.mitre.org/techniques/T1489/)](https://attack.mitre.org/techniques/T1489/)