﻿---
title: Suspicious Outlook Child Process
description: Identifies suspicious child processes spawned by MS Outlook, which can indicate a potential masquerading or the exploitation of a vulnerability on the...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_outlook_suspicious_child
products:
  - Elastic Security
---

# Suspicious Outlook Child Process
Identifies suspicious child processes spawned by MS Outlook, which can indicate a potential masquerading or the
exploitation of a vulnerability on the application causing it to execute code.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.process-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Tactic: Persistence
- Rule Type: BBR
- Data Source: Elastic Defend

**Version**: 4
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```eql
process where host.os.type == "windows" and event.type == "start" and
  process.parent.name : "outlook.exe" and
  not (
    (
      process.executable : (
        "?:\\Program Files\\*",
        "?:\\Program Files (x86)\\*",
        "?:\\Windows\\System32\\WerFault.exe",
        "?:\\Windows\\SysWOW64\\WerFault.exe",
        "?:\\Windows\\system32\\wermgr.exe",
        "?:\\Users\\*\\AppData\\Local\\Microsoft\\Teams\\current\\Teams.exe",
        "?:\\Users\\*\\AppData\\Local\\Temp\\NewOutlookInstall\\NewOutlookInstaller.exe",
        "?:\\Users\\*\\AppData\\Local\\Google\\Chrome\\Application\\chrome.exe",
        "?:\\Users\\*\\AppData\\Local\\Island\\Island\\Application\\Island.exe",
        "?:\\Users\\*\\AppData\\Local\\Mozilla Firefox\\firefox.exe",
        "?:\\Users\\*\\AppData\\Roaming\\Zoom\\bin\\Zoom.exe",
        "?:\\Windows\\System32\\IME\\SHARED\\IMEWDBLD.EXE",
        "?:\\Windows\\System32\\spool\\drivers\\x64\\*",
        "?:\\Windows\\System32\\prevhost.exe",
        "?:\\Windows\\System32\\dwwin.exe",
        "?:\\Windows\\System32\\mspaint.exe",
        "?:\\Windows\\SysWOW64\\mspaint.exe",
        "?:\\Windows\\System32\\notepad.exe",
        "?:\\Windows\\SysWOW64\\notepad.exe",
        "?:\\Windows\\System32\\smartscreen.exe",
        "?:\\Windows\\explorer.exe",
        "?:\\Windows\\splwow64.exe"
      ) and process.code_signature.trusted == true  
    ) or
    (
      process.name : "rundll32.exe" and
      process.args : "*hpmsn???.dll,MonitorPrintJobStatus*"
    )
  )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Masquerading
- Id: T1036
- Reference URL: [[https://attack.mitre.org/techniques/T1036/](https://attack.mitre.org/techniques/T1036/)](https://attack.mitre.org/techniques/T1036/)
- Sub Technique:
  - Name: Invalid Code Signature
- Id: T1036.001
- Reference URL: [[https://attack.mitre.org/techniques/T1036/001/](https://attack.mitre.org/techniques/T1036/001/)](https://attack.mitre.org/techniques/T1036/001/)
- Sub Technique:
  - Name: Match Legitimate Resource Name or Location
- Id: T1036.005
- Reference URL: [[https://attack.mitre.org/techniques/T1036/005/](https://attack.mitre.org/techniques/T1036/005/)](https://attack.mitre.org/techniques/T1036/005/)
- Technique:
  - Name: Process Injection
- Id: T1055
- Reference URL: [[https://attack.mitre.org/techniques/T1055/](https://attack.mitre.org/techniques/T1055/)](https://attack.mitre.org/techniques/T1055/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Compromise Host Software Binary
- Id: T1554
- Reference URL: [[https://attack.mitre.org/techniques/T1554/](https://attack.mitre.org/techniques/T1554/)](https://attack.mitre.org/techniques/T1554/)