﻿---
title: Windows Installer with Suspicious Properties
description: Identifies the execution of an installer from an archive or with suspicious properties. Adversaries may abuse msiexec.exe to launch local or network accessible...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_msiexec_installsource_archive_file
products:
  - Elastic Security
---

# Windows Installer with Suspicious Properties
Identifies the execution of an installer from an archive or with suspicious properties. Adversaries may abuse
msiexec.exe to launch local or network accessible MSI files in an attempt to bypass application whitelisting.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 60m
**Searches indices from**: `now-119m`
**Maximum alerts per execution**: 100
**References**:
- [[https://lolbas-project.github.io/lolbas/Binaries/Msiexec/](https://lolbas-project.github.io/lolbas/Binaries/Msiexec/)](https://lolbas-project.github.io/lolbas/Binaries/Msiexec/)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Rule Type: BBR
- Data Source: Elastic Defend

**Version**: 4
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```eql
sequence with maxspan=1m
  [registry where host.os.type == "windows" and event.type == "change" and process.name : "msiexec.exe" and
   (
    (registry.value : "InstallSource" and
     registry.data.strings : ("?:\\Users\\*\\Temp\\Temp?_*.zip\\*",
                             "?:\\Users\\*\\*.7z\\*",
                             "?:\\Users\\*\\*.rar\\*")) or

    (registry.value : ("DisplayName", "ProductName") and registry.data.strings : "SetupTest")
    )]
  [process where host.os.type == "windows" and event.action == "start" and
    process.parent.name : "msiexec.exe" and
    not process.name : "msiexec.exe" and
    not (process.executable : ("?:\\Program Files (x86)\\*.exe", "?:\\Program Files\\*.exe") and process.code_signature.trusted == true)]
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: System Binary Proxy Execution
- Id: T1218
- Reference URL: [[https://attack.mitre.org/techniques/T1218/](https://attack.mitre.org/techniques/T1218/)](https://attack.mitre.org/techniques/T1218/)
- Sub Technique:
  - Name: Msiexec
- Id: T1218.007
- Reference URL: [[https://attack.mitre.org/techniques/T1218/007/](https://attack.mitre.org/techniques/T1218/007/)](https://attack.mitre.org/techniques/T1218/007/)