﻿---
title: Potential Masquerading as System32 DLL
description: Identifies suspicious instances of default system32 DLLs either unsigned or signed with non-MS certificates. This can potentially indicate the attempt...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_masquerading_windows_dll
products:
  - Elastic Security
---

# Potential Masquerading as System32 DLL
Identifies suspicious instances of default system32 DLLs either unsigned or signed with non-MS certificates. This can
potentially indicate the attempt to masquerade as system DLLs, perform DLL Search Order Hijacking or backdoor and resign
legitimate DLLs.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.library-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- Data Source: Elastic Defend
- OS: Windows
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Tactic: Persistence
- Rule Type: BBR

**Version**: 109
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```eql
library where event.action == "load" and dll.Ext.relative_file_creation_time <= 3600 and
    not (
      dll.path : (
        "?:\\Windows\\System32\\*",
        "?:\\Windows\\SysWOW64\\*",
        "?:\\Windows\\SystemTemp\\*",
        "?:\\$WINDOWS.~BT\\NewOS\\Windows\\WinSxS\\*",
        "?:\\$WINDOWS.~BT\\NewOS\\Windows\\System32\\*",
        "?:\\$WINDOWS.~BT\\Sources\\*",
        "?:\\$WINDOWS.~BT\\Work\\*",
        "?:\\Windows\\WinSxS\\*",
        "?:\\Windows\\SoftwareDistribution\\Download\\*",
        "?:\\Windows\\assembly\\NativeImages_v*"
      )
    ) and
    not (
      dll.code_signature.subject_name in (
        "Microsoft Windows",
        "Microsoft Corporation",
        "Microsoft Windows Hardware Abstraction Layer Publisher",
        "Microsoft Windows Publisher",
        "Microsoft Windows 3rd party Component",
        "Microsoft 3rd Party Application Component"
      ) and dll.code_signature.trusted == true
    ) and not dll.code_signature.status : ("errorCode_endpoint*", "errorUntrustedRoot", "errorChaining") and
    dll.name : (
      "aadauthhelper.dll", "aadcloudap.dll", "aadjcsp.dll", "aadtb.dll", "aadwamextension.dll", "aarsvc.dll", "abovelockapphost.dll", "accessibilitycpl.dll", "accountaccessor.dll", "accountsrt.dll", "acgenral.dll", "aclayers.dll", "acledit.dll", "aclui.dll", "acmigration.dll", "acppage.dll", "acproxy.dll", "acspecfc.dll", "actioncenter.dll", "actioncentercpl.dll", "actionqueue.dll", "activationclient.dll", "activeds.dll", "activesynccsp.dll", "actxprxy.dll", "acwinrt.dll", "acxtrnal.dll", "adaptivecards.dll", "addressparser.dll", "adhapi.dll", "adhsvc.dll", "admtmpl.dll", "adprovider.dll", "adrclient.dll", "adsldp.dll", "adsldpc.dll", "adsmsext.dll", "adsnt.dll", "adtschema.dll", "advancedemojids.dll", "advapi32.dll", "advapi32res.dll", "advpack.dll", "aeevts.dll", "aeinv.dll", "aepic.dll", "ajrouter.dll", "altspace.dll", "amsi.dll", "amsiproxy.dll", "amstream.dll", "apds.dll", "aphostclient.dll", "aphostres.dll", "aphostservice.dll", "apisampling.dll", "apisetschema.dll", "apmon.dll", "apmonui.dll", "appcontracts.dll", "appextension.dll", "apphelp.dll", "apphlpdm.dll", "appidapi.dll", "appidsvc.dll", "appinfo.dll", "appinfoext.dll", "applicationframe.dll", "applockercsp.dll", "appmgmts.dll", "appmgr.dll", "appmon.dll", "appointmentapis.dll", "appraiser.dll", "appreadiness.dll", "apprepapi.dll", "appresolver.dll", "appsruprov.dll", "appvcatalog.dll", "appvclientps.dll", "appvetwclientres.dll", "appvintegration.dll", "appvmanifest.dll", "appvpolicy.dll", "appvpublishing.dll", "appvreporting.dll", "appvscripting.dll", "appvsentinel.dll", "appvstreamingux.dll", "appvstreammap.dll", "appvterminator.dll", "appxalluserstore.dll", "appxpackaging.dll", "appxsip.dll", "appxsysprep.dll", "archiveint.dll", "asferror.dll", "aspnet_counters.dll", "asycfilt.dll", "atl.dll", "atlthunk.dll", "atmlib.dll", "audioeng.dll", "audiohandlers.dll", "audiokse.dll", "audioses.dll", "audiosrv.dll", "auditcse.dll", "auditpolcore.dll", "auditpolmsg.dll", "authbroker.dll", "authbrokerui.dll", "authentication.dll", "authext.dll", "authfwcfg.dll", "authfwgp.dll", "authfwsnapin.dll", "authfwwizfwk.dll", "authhostproxy.dll", "authui.dll", "authz.dll", "autopilot.dll", "autopilotdiag.dll", "autoplay.dll", "autotimesvc.dll", "avicap32.dll", "avifil32.dll", "avrt.dll", "axinstsv.dll", "azroles.dll", "azroleui.dll", "azsqlext.dll", "basecsp.dll", "basesrv.dll", "batmeter.dll", "bcastdvrbroker.dll", "bcastdvrclient.dll", "bcastdvrcommon.dll", "bcd.dll", "bcdprov.dll", "bcdsrv.dll", "bcp47langs.dll", "bcp47mrm.dll", "bcrypt.dll", "bcryptprimitives.dll", "bdehdcfglib.dll", "bderepair.dll", "bdesvc.dll", "bdesysprep.dll", "bdeui.dll", "bfe.dll", "bi.dll", "bidispl.dll", "bindfltapi.dll", "bingasds.dll", "bingfilterds.dll", "bingmaps.dll", "biocredprov.dll", "bisrv.dll", "bitlockercsp.dll", "bitsigd.dll", "bitsperf.dll", "bitsproxy.dll", "biwinrt.dll", "blbevents.dll", "blbres.dll", "blb_ps.dll", "bluetoothapis.dll", "bnmanager.dll", "bootmenuux.dll", "bootstr.dll", "bootux.dll", "bootvid.dll", "bridgeres.dll", "brokerlib.dll", "browcli.dll", "browserbroker.dll", "browseui.dll", "btagservice.dll", "bthavctpsvc.dll", "bthavrcp.dll", "bthavrcpappsvc.dll", "bthci.dll", "bthpanapi.dll", "bthradiomedia.dll", "bthserv.dll", "bthtelemetry.dll", "btpanui.dll", "bwcontexthandler.dll", "cabapi.dll", "cabinet.dll", "cabview.dll", "callbuttons.dll", "cameracaptureui.dll", "capauthz.dll", "capiprovider.dll", "capisp.dll", "captureservice.dll", "castingshellext.dll", "castlaunch.dll", "catsrv.dll", "catsrvps.dll", "catsrvut.dll", "cbdhsvc.dll", "cca.dll", "cdd.dll", "cdosys.dll", "cdp.dll", "cdprt.dll", "cdpsvc.dll", "cdpusersvc.dll", "cemapi.dll", "certca.dll", "certcli.dll", "certcredprovider.dll", "certenc.dll", "certenroll.dll", "certenrollui.dll", "certmgr.dll", "certpkicmdlet.dll", "certpoleng.dll", "certprop.dll", "cewmdm.dll", "cfgbkend.dll", "cfgmgr32.dll", "cfgspcellular.dll", "cfgsppolicy.dll", "cflapi.dll", "cfmifs.dll", "cfmifsproxy.dll", "chakra.dll", "chakradiag.dll", "chakrathunk.dll", "chartv.dll", "chatapis.dll", "chkwudrv.dll", "chsstrokeds.dll", "chtbopomofods.dll", "chtcangjieds.dll", "chthkstrokeds.dll", "chtquickds.dll", "chxapds.dll", "chxdecoder.dll", "chxhapds.dll", "chxinputrouter.dll", "chxranker.dll", "ci.dll", "cic.dll", "cimfs.dll", "circoinst.dll", "ciwmi.dll", "clb.dll", "clbcatq.dll", "cldapi.dll", "cleanpccsp.dll", "clfsw32.dll", "cliconfg.dll", "clipboardserver.dll", "clipc.dll", "clipsvc.dll", "clipwinrt.dll", "cloudap.dll", "cloudidsvc.dll", "clrhost.dll", "clusapi.dll", "cmcfg32.dll", "cmdext.dll", "cmdial32.dll", "cmgrcspps.dll", "cmifw.dll", "cmintegrator.dll", "cmlua.dll", "cmpbk32.dll", "cmstplua.dll", "cmutil.dll", "cngcredui.dll", "cngprovider.dll", "cnvfat.dll", "cofiredm.dll", "colbact.dll", "colorcnv.dll", "colorui.dll", "combase.dll", "comcat.dll", "comctl32.dll", "comdlg32.dll", "coml2.dll", "comppkgsup.dll", "compstui.dll", "computecore.dll", "computenetwork.dll", "computestorage.dll", "comrepl.dll", "comres.dll", "comsnap.dll", "comsvcs.dll", "comuid.dll", "configmanager2.dll", "conhostv1.dll", "connect.dll", "consentux.dll", "consentuxclient.dll", "console.dll", "consolelogon.dll", "contactapis.dll", "container.dll", "coredpus.dll", "coreglobconfig.dll", "coremas.dll", "coremessaging.dll", "coremmres.dll", "coreshell.dll", "coreshellapi.dll", "coreuicomponents.dll", "correngine.dll", "courtesyengine.dll", "cpfilters.dll", "creddialogbroker.dll", "credprovhelper.dll", "credprovhost.dll", "credprovs.dll", "credprovslegacy.dll", "credssp.dll", "credui.dll", "crypt32.dll", "cryptbase.dll", "cryptcatsvc.dll", "cryptdlg.dll", "cryptdll.dll", "cryptext.dll", "cryptnet.dll", "cryptngc.dll", "cryptowinrt.dll", "cryptsp.dll", "cryptsvc.dll", "crypttpmeksvc.dll", "cryptui.dll", "cryptuiwizard.dll", "cryptxml.dll", "cscapi.dll", "cscdll.dll", "cscmig.dll", "cscobj.dll", "cscsvc.dll", "cscui.dll", "csplte.dll", "cspproxy.dll", "csrsrv.dll", "cxcredprov.dll", "c_g18030.dll", "c_gsm7.dll", "c_is2022.dll", "c_iscii.dll", "d2d1.dll", "d3d10.dll", "d3d10core.dll", "d3d10level9.dll", "d3d10warp.dll", "d3d10_1.dll", "d3d10_1core.dll", "d3d11.dll", "d3d11on12.dll", "d3d12.dll", "d3d12core.dll", "d3d8thk.dll", "d3d9.dll", "d3d9on12.dll", "d3dscache.dll", "dab.dll", "dabapi.dll", "daconn.dll", "dafbth.dll", "dafdnssd.dll", "dafescl.dll", "dafgip.dll", "dafiot.dll", "dafipp.dll", "dafmcp.dll", "dafpos.dll", "dafprintprovider.dll", "dafupnp.dll", "dafwcn.dll", "dafwfdprovider.dll", "dafwiprov.dll", "dafwsd.dll", "damediamanager.dll", "damm.dll", "das.dll", "dataclen.dll", "datusage.dll", "davclnt.dll", "davhlpr.dll", "davsyncprovider.dll", "daxexec.dll", "dbgcore.dll", "dbgeng.dll", "dbghelp.dll", "dbgmodel.dll", "dbnetlib.dll", "dbnmpntw.dll", "dciman32.dll", "dcntel.dll", "dcomp.dll", "ddaclsys.dll", "ddcclaimsapi.dll", "ddds.dll", "ddisplay.dll", "ddoiproxy.dll", "ddores.dll", "ddpchunk.dll", "ddptrace.dll", "ddputils.dll", "ddp_ps.dll", "ddraw.dll", "ddrawex.dll", "defragproxy.dll", "defragres.dll", "defragsvc.dll", "deploymentcsps.dll", "deskadp.dll", "deskmon.dll", "desktopshellext.dll", "devenum.dll", "deviceaccess.dll", "devicecenter.dll", "devicecredential.dll", "devicepairing.dll", "deviceuxres.dll", "devinv.dll", "devmgr.dll", "devobj.dll", "devpropmgr.dll", "devquerybroker.dll", "devrtl.dll", "dfdts.dll", "dfscli.dll", "dfshim.dll", "dfsshlex.dll", "dggpext.dll", "dhcpcmonitor.dll", "dhcpcore.dll", "dhcpcore6.dll", "dhcpcsvc.dll", "dhcpcsvc6.dll", "dhcpsapi.dll", "diagcpl.dll", "diagnosticlogcsp.dll", "diagperf.dll", "diagsvc.dll", "diagtrack.dll", "dialclient.dll", "dialserver.dll", "dictationmanager.dll", "difxapi.dll", "dimsjob.dll", "dimsroam.dll", "dinput.dll", "dinput8.dll", "direct2ddesktop.dll", "directml.dll", "discan.dll", "dismapi.dll", "dispbroker.dll", "dispex.dll", "display.dll", "displaymanager.dll", "dlnashext.dll", "dmappsres.dll", "dmcfgutils.dll", "dmcmnutils.dll", "dmcsps.dll", "dmdlgs.dll", "dmdskmgr.dll", "dmdskres.dll", "dmdskres2.dll", "dmenrollengine.dll", "dmintf.dll", "dmiso8601utils.dll", "dmloader.dll", "dmocx.dll", "dmoleaututils.dll", "dmpushproxy.dll", "dmpushroutercore.dll", "dmrcdecoder.dll", "dmrserver.dll", "dmsynth.dll", "dmusic.dll", "dmutil.dll", "dmvdsitf.dll", "dmwappushsvc.dll", "dmwmicsp.dll", "dmxmlhelputils.dll", "dnsapi.dll", "dnscmmc.dll", "dnsext.dll", "dnshc.dll", "dnsrslvr.dll", "docprop.dll", "dolbydecmft.dll", "domgmt.dll", "dosettings.dll", "dosvc.dll", "dot3api.dll", "dot3cfg.dll", "dot3conn.dll", "dot3dlg.dll", "dot3gpclnt.dll", "dot3gpui.dll", "dot3hc.dll", "dot3mm.dll", "dot3msm.dll", "dot3svc.dll", "dot3ui.dll", "dpapi.dll", "dpapiprovider.dll", "dpapisrv.dll", "dpnaddr.dll", "dpnathlp.dll", "dpnet.dll", "dpnhpast.dll", "dpnhupnp.dll", "dpnlobby.dll", "dps.dll", "dpx.dll", "drprov.dll", "drt.dll", "drtprov.dll", "drttransport.dll", "drvsetup.dll", "drvstore.dll", "dsauth.dll", "dsccore.dll", "dsccoreconfprov.dll", "dsclient.dll", "dscproxy.dll", "dsctimer.dll", "dsdmo.dll", "dskquota.dll", "dskquoui.dll", "dsound.dll", "dsparse.dll", "dsprop.dll", "dsquery.dll", "dsreg.dll", "dsregtask.dll", "dsrole.dll", "dssec.dll", "dssenh.dll", "dssvc.dll", "dsui.dll", "dsuiext.dll", "dswave.dll", "dtsh.dll", "ducsps.dll", "dui70.dll", "duser.dll", "dusmapi.dll", "dusmsvc.dll", "dwmapi.dll", "dwmcore.dll", "dwmghost.dll", "dwminit.dll", "dwmredir.dll", "dwmscene.dll", "dwrite.dll", "dxcore.dll", "dxdiagn.dll", "dxgi.dll", "dxgwdi.dll", "dxilconv.dll", "dxmasf.dll", "dxp.dll", "dxpps.dll", "dxptasksync.dll", "dxtmsft.dll", "dxtrans.dll", "dxva2.dll", "dynamoapi.dll", "eapp3hst.dll", "eappcfg.dll", "eappcfgui.dll", "eappgnui.dll", "eapphost.dll", "eappprxy.dll", "eapprovp.dll", "eapputil.dll", "eapsimextdesktop.dll", "eapsvc.dll", "eapteapauth.dll", "eapteapconfig.dll", "eapteapext.dll", "easconsent.dll", "easwrt.dll", "edgeangle.dll", "edgecontent.dll", "edgehtml.dll", "edgeiso.dll", "edgemanager.dll", "edpauditapi.dll", "edpcsp.dll", "edptask.dll", "edputil.dll", "eeprov.dll", "eeutil.dll", "efsadu.dll", "efscore.dll", "efsext.dll", "efslsaext.dll", "efssvc.dll", "efsutil.dll", "efswrt.dll", "ehstorapi.dll", "ehstorpwdmgr.dll", "ehstorshell.dll", "els.dll", "elscore.dll", "elshyph.dll", "elslad.dll", "elstrans.dll", "emailapis.dll", "embeddedmodesvc.dll", "emojids.dll", "encapi.dll", "energy.dll", "energyprov.dll", "energytask.dll", "enrollmentapi.dll", "enterpriseapncsp.dll", "enterprisecsps.dll", "enterpriseetw.dll", "eqossnap.dll", "errordetails.dll", "errordetailscore.dll", "es.dll", "esclprotocol.dll", "esclscan.dll", "esclwiadriver.dll", "esdsip.dll", "esent.dll", "esentprf.dll", "esevss.dll", "eshims.dll", "etwrundown.dll", "euiccscsp.dll", "eventaggregation.dll", "eventcls.dll", "evr.dll", "execmodelclient.dll", "execmodelproxy.dll", "explorerframe.dll", "exsmime.dll", "extrasxmlparser.dll", "f3ahvoas.dll", "facilitator.dll", "familysafetyext.dll", "faultrep.dll", "fcon.dll", "fdbth.dll", "fdbthproxy.dll", "fddevquery.dll", "fde.dll", "fdeploy.dll", "fdphost.dll", "fdpnp.dll", "fdprint.dll", "fdproxy.dll", "fdrespub.dll", "fdssdp.dll", "fdwcn.dll", "fdwnet.dll", "fdwsd.dll", "feclient.dll", "ffbroker.dll", "fhcat.dll", "fhcfg.dll", "fhcleanup.dll", "fhcpl.dll", "fhengine.dll", "fhevents.dll", "fhshl.dll", "fhsrchapi.dll", "fhsrchph.dll", "fhsvc.dll", "fhsvcctl.dll", "fhtask.dll", "fhuxadapter.dll", "fhuxapi.dll", "fhuxcommon.dll", "fhuxgraphics.dll", "fhuxpresentation.dll", "fidocredprov.dll", "filemgmt.dll", "filterds.dll", "findnetprinters.dll", "firewallapi.dll", "flightsettings.dll", "fltlib.dll", "fluencyds.dll", "fmapi.dll", "fmifs.dll", "fms.dll", "fntcache.dll", "fontext.dll", "fontprovider.dll", "fontsub.dll", "fphc.dll", "framedyn.dll", "framedynos.dll", "frameserver.dll", "frprov.dll", "fsutilext.dll", "fthsvc.dll", "fundisc.dll", "fveapi.dll", "fveapibase.dll", "fvecerts.dll", "fvecpl.dll", "fveskybackup.dll", "fveui.dll", "fvewiz.dll", "fwbase.dll", "fwcfg.dll", "fwmdmcsp.dll", "fwpolicyiomgr.dll", "fwpuclnt.dll", "fwremotesvr.dll", "gameinput.dll", "gamemode.dll", "gamestreamingext.dll", "gameux.dll", "gamingtcui.dll", "gcdef.dll", "gdi32.dll", "gdi32full.dll", "gdiplus.dll", "generaltel.dll", "geocommon.dll", "geolocation.dll", "getuname.dll", "glmf32.dll", "globinputhost.dll", "glu32.dll", "gmsaclient.dll", "gpapi.dll", "gpcsewrappercsp.dll", "gpedit.dll", "gpprefcl.dll", "gpprnext.dll", "gpscript.dll", "gpsvc.dll", "gptext.dll", "graphicscapture.dll", "graphicsperfsvc.dll", "groupinghc.dll", "hal.dll", "halextpl080.dll", "hascsp.dll", "hashtagds.dll", "hbaapi.dll", "hcproviders.dll", "hdcphandler.dll", "heatcore.dll", "helppaneproxy.dll", "hgcpl.dll", "hhsetup.dll", "hid.dll", "hidcfu.dll", "hidserv.dll", "hlink.dll", "hmkd.dll", "hnetcfg.dll", "hnetcfgclient.dll", "hnetmon.dll", "hologramworld.dll", "holoshellruntime.dll", "holoshextensions.dll", "hotplug.dll", "hrtfapo.dll", "httpapi.dll", "httpprxc.dll", "httpprxm.dll", "httpprxp.dll", "httpsdatasource.dll", "htui.dll", "hvhostsvc.dll", "hvloader.dll", "hvsigpext.dll", "hvsocket.dll", "hydrogen.dll", "ia2comproxy.dll", "ias.dll", "iasacct.dll", "iasads.dll", "iasdatastore.dll", "iashlpr.dll", "iasmigplugin.dll", "iasnap.dll", "iaspolcy.dll", "iasrad.dll", "iasrecst.dll", "iassam.dll", "iassdo.dll", "iassvcs.dll", "icfupgd.dll", "icm32.dll", "icmp.dll", "icmui.dll", "iconcodecservice.dll", "icsigd.dll", "icsvc.dll", "icsvcext.dll", "icu.dll", "icuin.dll", "icuuc.dll", "idctrls.dll", "idlisten.dll", "idndl.dll", "idstore.dll", "ieadvpack.dll", "ieapfltr.dll", "iedkcs32.dll", "ieframe.dll", "iemigplugin.dll", "iepeers.dll", "ieproxy.dll", "iernonce.dll", "iertutil.dll", "iesetup.dll", "iesysprep.dll", "ieui.dll", "ifmon.dll", "ifsutil.dll", "ifsutilx.dll", "igddiag.dll", "ihds.dll", "ikeext.dll", "imagehlp.dll", "imageres.dll", "imagesp1.dll", "imapi.dll", "imapi2.dll", "imapi2fs.dll", "imgutil.dll", "imm32.dll", "implatsetup.dll", "indexeddblegacy.dll", "inetcomm.dll", "inetmib1.dll", "inetpp.dll", "inetppui.dll", "inetres.dll", "inked.dll", "inkobjcore.dll", "inproclogger.dll", "input.dll", "inputcloudstore.dll", "inputcontroller.dll", "inputhost.dll", "inputservice.dll", "inputswitch.dll", "inseng.dll", "installservice.dll", "internetmail.dll", "internetmailcsp.dll", "invagent.dll", "iologmsg.dll", "iphlpapi.dll", "iphlpsvc.dll", "ipnathlp.dll", "ipnathlpclient.dll", "ippcommon.dll", "ippcommonproxy.dll", "iprtprio.dll", "iprtrmgr.dll", "ipsecsnp.dll", "ipsecsvc.dll", "ipsmsnap.dll", "ipxlatcfg.dll", "iri.dll", "iscsicpl.dll", "iscsidsc.dll", "iscsied.dll", "iscsiexe.dll", "iscsilog.dll", "iscsium.dll", "iscsiwmi.dll", "iscsiwmiv2.dll", "ism.dll", "itircl.dll", "itss.dll", "iuilp.dll", "iumbase.dll", "iumcrypt.dll", "iumdll.dll", "iumsdk.dll", "iyuv_32.dll", "joinproviderol.dll", "joinutil.dll", "jpmapcontrol.dll", "jpndecoder.dll", "jpninputrouter.dll", "jpnranker.dll", "jpnserviceds.dll", "jscript.dll", "jscript9.dll", "jscript9diag.dll", "jsproxy.dll", "kbd101.dll", "kbd101a.dll", "kbd101b.dll", "kbd101c.dll", "kbd103.dll", "kbd106.dll", "kbd106n.dll", "kbda1.dll", "kbda2.dll", "kbda3.dll", "kbdadlm.dll", "kbdal.dll", "kbdarme.dll", "kbdarmph.dll", "kbdarmty.dll", "kbdarmw.dll", "kbdax2.dll", "kbdaze.dll", "kbdazel.dll", "kbdazst.dll", "kbdbash.dll", "kbdbe.dll", "kbdbene.dll", "kbdbgph.dll", "kbdbgph1.dll", "kbdbhc.dll", "kbdblr.dll", "kbdbr.dll", "kbdbu.dll", "kbdbug.dll", "kbdbulg.dll", "kbdca.dll", "kbdcan.dll", "kbdcher.dll", "kbdcherp.dll", "kbdcr.dll", "kbdcz.dll", "kbdcz1.dll", "kbdcz2.dll", "kbdda.dll", "kbddiv1.dll", "kbddiv2.dll", "kbddv.dll", "kbddzo.dll", "kbdes.dll", "kbdest.dll", "kbdfa.dll", "kbdfar.dll", "kbdfc.dll", "kbdfi.dll", "kbdfi1.dll", "kbdfo.dll", "kbdfr.dll", "kbdfthrk.dll", "kbdgae.dll", "kbdgeo.dll", "kbdgeoer.dll", "kbdgeome.dll", "kbdgeooa.dll", "kbdgeoqw.dll", "kbdgkl.dll", "kbdgn.dll", "kbdgr.dll", "kbdgr1.dll", "kbdgrlnd.dll", "kbdgthc.dll", "kbdhau.dll", "kbdhaw.dll", "kbdhe.dll", "kbdhe220.dll", "kbdhe319.dll", "kbdheb.dll", "kbdhebl3.dll", "kbdhela2.dll", "kbdhela3.dll", "kbdhept.dll", "kbdhu.dll", "kbdhu1.dll", "kbdibm02.dll", "kbdibo.dll", "kbdic.dll", "kbdinasa.dll", "kbdinbe1.dll", "kbdinbe2.dll", "kbdinben.dll", "kbdindev.dll", "kbdinen.dll", "kbdinguj.dll", "kbdinhin.dll", "kbdinkan.dll", "kbdinmal.dll", "kbdinmar.dll", "kbdinori.dll", "kbdinpun.dll", "kbdintam.dll", "kbdintel.dll", "kbdinuk2.dll", "kbdir.dll", "kbdit.dll", "kbdit142.dll", "kbdiulat.dll", "kbdjav.dll", "kbdjpn.dll", "kbdkaz.dll", "kbdkhmr.dll", "kbdkni.dll", "kbdkor.dll", "kbdkurd.dll", "kbdkyr.dll", "kbdla.dll", "kbdlao.dll", "kbdlisub.dll", "kbdlisus.dll", "kbdlk41a.dll", "kbdlt.dll", "kbdlt1.dll", "kbdlt2.dll", "kbdlv.dll", "kbdlv1.dll", "kbdlvst.dll", "kbdmac.dll", "kbdmacst.dll", "kbdmaori.dll", "kbdmlt47.dll", "kbdmlt48.dll", "kbdmon.dll", "kbdmonmo.dll", "kbdmonst.dll", "kbdmyan.dll", "kbdne.dll", "kbdnec.dll", "kbdnec95.dll", "kbdnecat.dll", "kbdnecnt.dll", "kbdnepr.dll", "kbdnko.dll", "kbdno.dll", "kbdno1.dll", "kbdnso.dll", "kbdntl.dll", "kbdogham.dll", "kbdolch.dll", "kbdoldit.dll", "kbdosa.dll", "kbdosm.dll", "kbdpash.dll", "kbdphags.dll", "kbdpl.dll", "kbdpl1.dll", "kbdpo.dll", "kbdro.dll", "kbdropr.dll", "kbdrost.dll", "kbdru.dll", "kbdru1.dll", "kbdrum.dll", "kbdsf.dll", "kbdsg.dll", "kbdsl.dll", "kbdsl1.dll", "kbdsmsfi.dll", "kbdsmsno.dll", "kbdsn1.dll", "kbdsora.dll", "kbdsorex.dll", "kbdsors1.dll", "kbdsorst.dll", "kbdsp.dll", "kbdsw.dll", "kbdsw09.dll", "kbdsyr1.dll", "kbdsyr2.dll", "kbdtaile.dll", "kbdtajik.dll", "kbdtam99.dll", "kbdtat.dll", "kbdth0.dll", "kbdth1.dll", "kbdth2.dll", "kbdth3.dll", "kbdtifi.dll", "kbdtifi2.dll", "kbdtiprc.dll", "kbdtiprd.dll", "kbdtt102.dll", "kbdtuf.dll", "kbdtuq.dll", "kbdturme.dll", "kbdtzm.dll", "kbdughr.dll", "kbdughr1.dll", "kbduk.dll", "kbdukx.dll", "kbdur.dll", "kbdur1.dll", "kbdurdu.dll", "kbdus.dll", "kbdusa.dll", "kbdusl.dll", "kbdusr.dll", "kbdusx.dll", "kbduzb.dll", "kbdvntc.dll", "kbdwol.dll", "kbdyak.dll", "kbdyba.dll", "kbdycc.dll", "kbdycl.dll", "kd.dll", "kdcom.dll", "kdcpw.dll", "kdhvcom.dll", "kdnet.dll", "kdnet_uart16550.dll", "kdscli.dll", "kdstub.dll", "kdusb.dll", "kd_02_10df.dll", "kd_02_10ec.dll", "kd_02_1137.dll", "kd_02_14e4.dll", "kd_02_15b3.dll", "kd_02_1969.dll", "kd_02_19a2.dll", "kd_02_1af4.dll", "kd_02_8086.dll", "kd_07_1415.dll", "kd_0c_8086.dll", "kerbclientshared.dll", "kerberos.dll", "kernel32.dll", "kernelbase.dll", "keycredmgr.dll", "keyiso.dll", "keymgr.dll", "knobscore.dll", "knobscsp.dll", "ksuser.dll", "ktmw32.dll", "l2gpstore.dll", "l2nacp.dll", "l2sechc.dll", "laprxy.dll", "legacynetux.dll", "lfsvc.dll", "libcrypto.dll", "licensemanager.dll", "licensingcsp.dll", "licensingdiagspp.dll", "licensingwinrt.dll", "licmgr10.dll", "linkinfo.dll", "lltdapi.dll", "lltdres.dll", "lltdsvc.dll", "lmhsvc.dll", "loadperf.dll", "localsec.dll", "localspl.dll", "localui.dll", "locationapi.dll", "lockappbroker.dll", "lockcontroller.dll", "lockscreendata.dll", "loghours.dll", "logoncli.dll", "logoncontroller.dll", "lpasvc.dll", "lpk.dll", "lsasrv.dll", "lscshostpolicy.dll", "lsm.dll", "lsmproxy.dll", "lstelemetry.dll", "luainstall.dll", "luiapi.dll", "lz32.dll", "magnification.dll", "maintenanceui.dll", "manageci.dll", "mapconfiguration.dll", "mapcontrolcore.dll", "mapgeocoder.dll", "mapi32.dll", "mapistub.dll", "maprouter.dll", "mapsbtsvc.dll", "mapsbtsvcproxy.dll", "mapscsp.dll", "mapsstore.dll", "mapstoasttask.dll", "mapsupdatetask.dll", "mbaeapi.dll", "mbaeapipublic.dll", "mbaexmlparser.dll", "mbmediamanager.dll", "mbsmsapi.dll", "mbussdapi.dll", "mccsengineshared.dll", "mccspal.dll", "mciavi32.dll", "mcicda.dll", "mciqtz32.dll", "mciseq.dll", "mciwave.dll", "mcrecvsrc.dll", "mdmcommon.dll", "mdmdiagnostics.dll", "mdminst.dll", "mdmmigrator.dll", "mdmregistration.dll", "memorydiagnostic.dll", "messagingservice.dll", "mf.dll", "mf3216.dll", "mfaacenc.dll", "mfasfsrcsnk.dll", "mfaudiocnv.dll", "mfc42.dll", "mfc42u.dll", "mfcaptureengine.dll", "mfcore.dll", "mfcsubs.dll", "mfds.dll", "mfdvdec.dll", "mferror.dll", "mfh263enc.dll", "mfh264enc.dll", "mfksproxy.dll", "mfmediaengine.dll", "mfmjpegdec.dll", "mfmkvsrcsnk.dll", "mfmp4srcsnk.dll", "mfmpeg2srcsnk.dll", "mfnetcore.dll", "mfnetsrc.dll", "mfperfhelper.dll", "mfplat.dll", "mfplay.dll", "mfps.dll", "mfreadwrite.dll", "mfsensorgroup.dll", "mfsrcsnk.dll", "mfsvr.dll", "mftranscode.dll", "mfvdsp.dll", "mfvfw.dll", "mfwmaaec.dll", "mgmtapi.dll", "mi.dll", "mibincodec.dll", "midimap.dll", "migisol.dll", "miguiresource.dll", "mimefilt.dll", "mimofcodec.dll", "minstoreevents.dll", "miracastinputmgr.dll", "miracastreceiver.dll", "mirrordrvcompat.dll", "mispace.dll", "mitigationclient.dll", "miutils.dll", "mlang.dll", "mmcbase.dll", "mmcndmgr.dll", "mmcshext.dll", "mmdevapi.dll", "mmgaclient.dll", "mmgaproxystub.dll", "mmres.dll", "mobilenetworking.dll", "modemui.dll", "modernexecserver.dll", "moricons.dll", "moshost.dll", "moshostclient.dll", "moshostcore.dll", "mosstorage.dll", "mp3dmod.dll", "mp43decd.dll", "mp4sdecd.dll", "mpeval.dll", "mpg4decd.dll", "mpr.dll", "mprapi.dll", "mprddm.dll", "mprdim.dll", "mprext.dll", "mprmsg.dll", "mpssvc.dll", "mpunits.dll", "mrmcorer.dll", "mrmdeploy.dll", "mrmindexer.dll", "mrt100.dll", "mrt_map.dll", "msaatext.dll", "msac3enc.dll", "msacm32.dll", "msafd.dll", "msajapi.dll", "msalacdecoder.dll", "msalacencoder.dll", "msamrnbdecoder.dll", "msamrnbencoder.dll", "msamrnbsink.dll", "msamrnbsource.dll", "msasn1.dll", "msauddecmft.dll", "msaudite.dll", "msauserext.dll", "mscandui.dll", "mscat32.dll", "msclmd.dll", "mscms.dll", "mscoree.dll", "mscorier.dll", "mscories.dll", "msctf.dll", "msctfmonitor.dll", "msctfp.dll", "msctfui.dll", "msctfuimanager.dll", "msdadiag.dll", "msdart.dll", "msdelta.dll", "msdmo.dll", "msdrm.dll", "msdtckrm.dll", "msdtclog.dll", "msdtcprx.dll", "msdtcspoffln.dll", "msdtctm.dll", "msdtcuiu.dll", "msdtcvsp1res.dll", "msfeeds.dll", "msfeedsbs.dll", "msflacdecoder.dll", "msflacencoder.dll", "msftedit.dll", "msheif.dll", "mshtml.dll", "mshtmldac.dll", "mshtmled.dll", "mshtmler.dll", "msi.dll", "msicofire.dll", "msidcrl40.dll", "msident.dll", "msidle.dll", "msidntld.dll", "msieftp.dll", "msihnd.dll", "msiltcfg.dll", "msimg32.dll", "msimsg.dll", "msimtf.dll", "msisip.dll", "msiso.dll", "msiwer.dll", "mskeyprotcli.dll", "mskeyprotect.dll", "msls31.dll", "msmpeg2adec.dll", "msmpeg2enc.dll", "msmpeg2vdec.dll", "msobjs.dll", "msoert2.dll", "msopusdecoder.dll", "mspatcha.dll", "mspatchc.dll", "msphotography.dll", "msports.dll", "msprivs.dll", "msrahc.dll", "msrating.dll", "msrawimage.dll", "msrdc.dll", "msrdpwebaccess.dll", "msrle32.dll", "msscntrs.dll", "mssecuser.dll", "mssign32.dll", "mssip32.dll", "mssitlb.dll", "mssph.dll", "mssprxy.dll", "mssrch.dll", "mssvp.dll", "mstask.dll", "mstextprediction.dll", "mstscax.dll", "msutb.dll", "msv1_0.dll", "msvcirt.dll", "msvcp110_win.dll", "msvcp120_clr0400.dll", "msvcp140_clr0400.dll", "msvcp60.dll", "msvcp_win.dll", "msvcr100_clr0400.dll", "msvcr120_clr0400.dll", "msvcrt.dll", "msvfw32.dll", "msvidc32.dll", "msvidctl.dll", "msvideodsp.dll", "msvp9dec.dll", "msvproc.dll", "msvpxenc.dll", "mswb7.dll", "mswebp.dll", "mswmdm.dll", "mswsock.dll", "msxml3.dll", "msxml3r.dll", "msxml6.dll", "msxml6r.dll", "msyuv.dll", "mtcmodel.dll", "mtf.dll", "mtfappserviceds.dll", "mtfdecoder.dll", "mtffuzzyds.dll", "mtfserver.dll", "mtfspellcheckds.dll", "mtxclu.dll", "mtxdm.dll", "mtxex.dll", "mtxoci.dll", "muifontsetup.dll", "mycomput.dll", "mydocs.dll", "napcrypt.dll", "napinsp.dll", "naturalauth.dll", "naturallanguage6.dll", "navshutdown.dll", "ncaapi.dll", "ncasvc.dll", "ncbservice.dll", "ncdautosetup.dll", "ncdprop.dll", "nci.dll", "ncobjapi.dll", "ncrypt.dll", "ncryptprov.dll", "ncryptsslp.dll", "ncsi.dll", "ncuprov.dll", "nddeapi.dll", "ndfapi.dll", "ndfetw.dll", "ndfhcdiscovery.dll", "ndishc.dll", "ndproxystub.dll", "nduprov.dll", "negoexts.dll", "netapi32.dll", "netbios.dll", "netcenter.dll", "netcfgx.dll", "netcorehc.dll", "netdiagfx.dll", "netdriverinstall.dll", "netevent.dll", "netfxperf.dll", "neth.dll", "netid.dll", "netiohlp.dll", "netjoin.dll", "netlogon.dll", "netman.dll", "netmsg.dll", "netplwiz.dll", "netprofm.dll", "netprofmsvc.dll", "netprovfw.dll", "netprovisionsp.dll", "netsetupapi.dll", "netsetupengine.dll", "netsetupshim.dll", "netsetupsvc.dll", "netshell.dll", "nettrace.dll", "netutils.dll", "networkexplorer.dll", "networkhelper.dll", "networkicon.dll", "networkproxycsp.dll", "networkstatus.dll", "networkuxbroker.dll", "newdev.dll", "nfcradiomedia.dll", "ngccredprov.dll", "ngcctnr.dll", "ngcctnrsvc.dll", "ngcisoctnr.dll", "ngckeyenum.dll", "ngcksp.dll", "ngclocal.dll", "ngcpopkeysrv.dll", "ngcprocsp.dll", "ngcrecovery.dll", "ngcsvc.dll", "ngctasks.dll", "ninput.dll", "nlaapi.dll", "nlahc.dll", "nlasvc.dll", "nlhtml.dll", "nlmgp.dll", "nlmproxy.dll", "nlmsprep.dll", "nlsbres.dll", "nlsdata0000.dll", "nlsdata0009.dll", "nlsdl.dll", "nlslexicons0009.dll", "nmadirect.dll", "normaliz.dll", "npmproxy.dll", "npsm.dll", "nrpsrv.dll", "nshhttp.dll", "nshipsec.dll", "nshwfp.dll", "nsi.dll", "nsisvc.dll", "ntasn1.dll", "ntdll.dll", "ntdsapi.dll", "ntlanman.dll", "ntlanui2.dll", "ntlmshared.dll", "ntmarta.dll", "ntprint.dll", "ntshrui.dll", "ntvdm64.dll", "objsel.dll", "occache.dll", "ocsetapi.dll", "odbc32.dll", "odbcbcp.dll", "odbcconf.dll", "odbccp32.dll", "odbccr32.dll", "odbccu32.dll", "odbcint.dll", "odbctrac.dll", "oemlicense.dll", "offfilt.dll", "officecsp.dll", "offlinelsa.dll", "offlinesam.dll", "offreg.dll", "ole32.dll", "oleacc.dll", "oleacchooks.dll", "oleaccrc.dll", "oleaut32.dll", "oledlg.dll", "oleprn.dll", "omadmagent.dll", "omadmapi.dll", "onebackuphandler.dll", "onex.dll", "onexui.dll", "opcservices.dll", "opengl32.dll", "ortcengine.dll", "osbaseln.dll", "osksupport.dll", "osuninst.dll", "p2p.dll", "p2pgraph.dll", "p2pnetsh.dll", "p2psvc.dll", "packager.dll", "panmap.dll", "pautoenr.dll", "pcacli.dll", "pcadm.dll", "pcaevts.dll", "pcasvc.dll", "pcaui.dll", "pcpksp.dll", "pcsvdevice.dll", "pcwum.dll", "pcwutl.dll", "pdh.dll", "pdhui.dll", "peerdist.dll", "peerdistad.dll", "peerdistcleaner.dll", "peerdistsh.dll", "peerdistsvc.dll", "peopleapis.dll", "peopleband.dll", "perceptiondevice.dll", "perfctrs.dll", "perfdisk.dll", "perfnet.dll", "perfos.dll", "perfproc.dll", "perfts.dll", "phoneom.dll", "phoneproviders.dll", "phoneservice.dll", "phoneserviceres.dll", "phoneutil.dll", "phoneutilres.dll", "photowiz.dll", "pickerplatform.dll", "pid.dll", "pidgenx.dll", "pifmgr.dll", "pimstore.dll", "pkeyhelper.dll", "pktmonapi.dll", "pku2u.dll", "pla.dll", "playlistfolder.dll", "playsndsrv.dll", "playtodevice.dll", "playtomanager.dll", "playtomenu.dll", "playtoreceiver.dll", "ploptin.dll", "pmcsnap.dll", "pngfilt.dll", "pnidui.dll", "pnpclean.dll", "pnppolicy.dll", "pnpts.dll", "pnpui.dll", "pnpxassoc.dll", "pnpxassocprx.dll", "pnrpauto.dll", "pnrphc.dll", "pnrpnsp.dll", "pnrpsvc.dll", "policymanager.dll", "polstore.dll", "posetup.dll", "posyncservices.dll", "pots.dll", "powercpl.dll", "powrprof.dll", "ppcsnap.dll", "prauthproviders.dll", "prflbmsg.dll", "printui.dll", "printwsdahost.dll", "prm0009.dll", "prncache.dll", "prnfldr.dll", "prnntfy.dll", "prntvpt.dll", "profapi.dll", "profext.dll", "profprov.dll", "profsvc.dll", "profsvcext.dll", "propsys.dll", "provcore.dll", "provdatastore.dll", "provdiagnostics.dll", "provengine.dll", "provhandlers.dll", "provisioningcsp.dll", "provmigrate.dll", "provops.dll", "provplugineng.dll", "provsysprep.dll", "provthrd.dll", "proximitycommon.dll", "proximityservice.dll", "prvdmofcomp.dll", "psapi.dll", "pshed.dll", "psisdecd.dll", "psmsrv.dll", "pstask.dll", "pstorec.dll", "ptpprov.dll", "puiapi.dll", "puiobj.dll", "pushtoinstall.dll", "pwlauncher.dll", "pwrshplugin.dll", "pwsso.dll", "qasf.dll", "qcap.dll", "qdv.dll", "qdvd.dll", "qedit.dll", "qedwipes.dll", "qmgr.dll", "query.dll", "quiethours.dll", "qwave.dll", "racengn.dll", "racpldlg.dll", "radardt.dll", "radarrs.dll", "radcui.dll", "rasadhlp.dll", "rasapi32.dll", "rasauto.dll", "raschap.dll", "raschapext.dll", "rasctrs.dll", "rascustom.dll", "rasdiag.dll", "rasdlg.dll", "rasgcw.dll", "rasman.dll", "rasmans.dll", "rasmbmgr.dll", "rasmediamanager.dll", "rasmm.dll", "rasmontr.dll", "rasplap.dll", "rasppp.dll", "rastapi.dll", "rastls.dll", "rastlsext.dll", "rdbui.dll", "rdpbase.dll", "rdpcfgex.dll", "rdpcore.dll", "rdpcorets.dll", "rdpencom.dll", "rdpendp.dll", "rdpnano.dll", "rdpsaps.dll", "rdpserverbase.dll", "rdpsharercom.dll", "rdpudd.dll", "rdpviewerax.dll", "rdsappxhelper.dll", "rdsdwmdr.dll", "rdvvmtransport.dll", "rdxservice.dll", "rdxtaskfactory.dll", "reagent.dll", "reagenttask.dll", "recovery.dll", "regapi.dll", "regctrl.dll", "regidle.dll", "regsvc.dll", "reguwpapi.dll", "reinfo.dll", "remotepg.dll", "remotewipecsp.dll", "reportingcsp.dll", "resampledmo.dll", "resbparser.dll", "reseteng.dll", "resetengine.dll", "resetengonline.dll", "resourcemapper.dll", "resutils.dll", "rgb9rast.dll", "riched20.dll", "riched32.dll", "rjvmdmconfig.dll", "rmapi.dll", "rmclient.dll", "rnr20.dll", "roamingsecurity.dll", "rometadata.dll", "rotmgr.dll", "rpcepmap.dll", "rpchttp.dll", "rpcns4.dll", "rpcnsh.dll", "rpcrt4.dll", "rpcrtremote.dll", "rpcss.dll", "rsaenh.dll", "rshx32.dll", "rstrtmgr.dll", "rtffilt.dll", "rtm.dll", "rtmediaframe.dll", "rtmmvrortc.dll", "rtutils.dll", "rtworkq.dll", "rulebasedds.dll", "samcli.dll", "samlib.dll", "samsrv.dll", "sas.dll", "sbe.dll", "sbeio.dll", "sberes.dll", "sbservicetrigger.dll", "scansetting.dll", "scardbi.dll", "scarddlg.dll", "scardsvr.dll", "scavengeui.dll", "scdeviceenum.dll", "scecli.dll", "scesrv.dll", "schannel.dll", "schedcli.dll", "schedsvc.dll", "scksp.dll", "scripto.dll", "scrobj.dll", "scrptadm.dll", "scrrun.dll", "sdcpl.dll", "sdds.dll", "sdengin2.dll", "sdfhost.dll", "sdhcinst.dll", "sdiageng.dll", "sdiagprv.dll", "sdiagschd.dll", "sdohlp.dll", "sdrsvc.dll", "sdshext.dll", "searchfolder.dll", "sechost.dll", "seclogon.dll", "secproc.dll", "secproc_isv.dll", "secproc_ssp.dll", "secproc_ssp_isv.dll", "secur32.dll", "security.dll", "semgrps.dll", "semgrsvc.dll", "sendmail.dll", "sens.dll", "sensapi.dll", "sensorsapi.dll", "sensorscpl.dll", "sensorservice.dll", "sensorsnativeapi.dll", "sensorsutilsv2.dll", "sensrsvc.dll", "serialui.dll", "servicinguapi.dll", "serwvdrv.dll", "sessenv.dll", "setbcdlocale.dll", "settingmonitor.dll", "settingsync.dll", "settingsynccore.dll", "setupapi.dll", "setupcl.dll", "setupcln.dll", "setupetw.dll", "sfc.dll", "sfc_os.dll", "sgrmenclave.dll", "shacct.dll", "shacctprofile.dll", "sharedpccsp.dll", "sharedrealitysvc.dll", "sharehost.dll", "sharemediacpl.dll", "shcore.dll", "shdocvw.dll", "shell32.dll", "shellstyle.dll", "shfolder.dll", "shgina.dll", "shimeng.dll", "shimgvw.dll", "shlwapi.dll", "shpafact.dll", "shsetup.dll", "shsvcs.dll", "shunimpl.dll", "shutdownext.dll", "shutdownux.dll", "shwebsvc.dll", "signdrv.dll", "simauth.dll", "simcfg.dll", "skci.dll", "slc.dll", "slcext.dll", "slwga.dll", "smartscreenps.dll", "smbhelperclass.dll", "smbwmiv2.dll", "smiengine.dll", "smphost.dll", "smsroutersvc.dll", "sndvolsso.dll", "snmpapi.dll", "socialapis.dll", "softkbd.dll", "softpub.dll", "sortwindows61.dll", "sortwindows62.dll", "spacebridge.dll", "spacecontrol.dll", "spatializerapo.dll", "spatialstore.dll", "spbcd.dll", "speechpal.dll", "spfileq.dll", "spinf.dll", "spmpm.dll", "spnet.dll", "spoolss.dll", "spopk.dll", "spp.dll", "sppc.dll", "sppcext.dll", "sppcomapi.dll", "sppcommdlg.dll", "sppinst.dll", "sppnp.dll", "sppobjs.dll", "sppwinob.dll", "sppwmi.dll", "spwinsat.dll", "spwizeng.dll", "spwizimg.dll", "spwizres.dll", "spwmp.dll", "sqlsrv32.dll", "sqmapi.dll", "srchadmin.dll", "srclient.dll", "srcore.dll", "srevents.dll", "srh.dll", "srhelper.dll", "srm.dll", "srmclient.dll", "srmlib.dll", "srmscan.dll", "srmshell.dll", "srmstormod.dll", "srmtrace.dll", "srm_ps.dll", "srpapi.dll", "srrstr.dll", "srumapi.dll", "srumsvc.dll", "srvcli.dll", "srvsvc.dll", "srwmi.dll", "sscore.dll", "sscoreext.dll", "ssdm.dll", "ssdpapi.dll", "ssdpsrv.dll", "sspicli.dll", "sspisrv.dll", "ssshim.dll", "sstpsvc.dll", "starttiledata.dll", "startupscan.dll", "stclient.dll", "sti.dll", "sti_ci.dll", "stobject.dll", "storageusage.dll", "storagewmi.dll", "storewuauth.dll", "storprop.dll", "storsvc.dll", "streamci.dll", "structuredquery.dll", "sud.dll", "svf.dll", "svsvc.dll", "swprv.dll", "sxproxy.dll", "sxs.dll", "sxshared.dll", "sxssrv.dll", "sxsstore.dll", "synccenter.dll", "synccontroller.dll", "synchostps.dll", "syncproxy.dll", "syncreg.dll", "syncres.dll", "syncsettings.dll", "syncutil.dll", "sysclass.dll", "sysfxui.dll", "sysmain.dll", "sysntfy.dll", "syssetup.dll", "systemcpl.dll", "t2embed.dll", "tabbtn.dll", "tabbtnex.dll", "tabsvc.dll", "tapi3.dll", "tapi32.dll", "tapilua.dll", "tapimigplugin.dll", "tapiperf.dll", "tapisrv.dll", "tapisysprep.dll", "tapiui.dll", "taskapis.dll", "taskbarcpl.dll", "taskcomp.dll", "taskschd.dll", "taskschdps.dll", "tbauth.dll", "tbs.dll", "tcbloader.dll", "tcpipcfg.dll", "tcpmib.dll", "tcpmon.dll", "tcpmonui.dll", "tdh.dll", "tdlmigration.dll", "tellib.dll", "termmgr.dll", "termsrv.dll", "tetheringclient.dll", "tetheringmgr.dll", "tetheringservice.dll", "tetheringstation.dll", "textshaping.dll", "themecpl.dll", "themeservice.dll", "themeui.dll", "threadpoolwinrt.dll", "thumbcache.dll", "timebrokerclient.dll", "timebrokerserver.dll", "timesync.dll", "timesynctask.dll", "tlscsp.dll", "tokenbinding.dll", "tokenbroker.dll", "tokenbrokerui.dll", "tpmcertresources.dll", "tpmcompc.dll", "tpmtasks.dll", "tpmvsc.dll", "tquery.dll", "traffic.dll", "transportdsa.dll", "trie.dll", "trkwks.dll", "tsbyuv.dll", "tscfgwmi.dll", "tserrredir.dll", "tsf3gip.dll", "tsgqec.dll", "tsmf.dll", "tspkg.dll", "tspubwmi.dll", "tssessionux.dll", "tssrvlic.dll", "tsworkspace.dll", "ttdloader.dll", "ttdplm.dll", "ttdrecord.dll", "ttdrecordcpu.dll", "ttlsauth.dll", "ttlscfg.dll", "ttlsext.dll", "tvratings.dll", "twext.dll", "twinapi.dll", "twinui.dll", "txflog.dll", "txfw32.dll", "tzautoupdate.dll", "tzres.dll", "tzsyncres.dll", "ubpm.dll", "ucmhc.dll", "ucrtbase.dll", "ucrtbase_clr0400.dll", "ucrtbase_enclave.dll", "udhisapi.dll", "udwm.dll", "ueficsp.dll", "uexfat.dll", "ufat.dll", "uiamanager.dll", "uianimation.dll", "uiautomationcore.dll", "uicom.dll", "uireng.dll", "uiribbon.dll", "uiribbonres.dll", "ulib.dll", "umb.dll", "umdmxfrm.dll", "umpdc.dll", "umpnpmgr.dll", "umpo-overrides.dll", "umpo.dll", "umpoext.dll", "umpowmi.dll", "umrdp.dll", "unattend.dll", "unenrollhook.dll", "unimdmat.dll", "uniplat.dll", "unistore.dll", "untfs.dll", "updateagent.dll", "updatecsp.dll", "updatepolicy.dll", "upnp.dll", "upnphost.dll", "upshared.dll", "urefs.dll", "urefsv1.dll", "ureg.dll", "url.dll", "urlmon.dll", "usbcapi.dll", "usbceip.dll", "usbmon.dll", "usbperf.dll", "usbpmapi.dll", "usbtask.dll", "usbui.dll", "user32.dll", "usercpl.dll", "userdataservice.dll", "userdatatimeutil.dll", "userenv.dll", "userinitext.dll", "usermgr.dll", "usermgrcli.dll", "usermgrproxy.dll", "usoapi.dll", "usocoreps.dll", "usosvc.dll", "usp10.dll", "ustprov.dll", "utcutil.dll", "utildll.dll", "uudf.dll", "uvcmodel.dll", "uwfcfgmgmt.dll", "uwfcsp.dll", "uwfservicingapi.dll", "uxinit.dll", "uxlib.dll", "uxlibres.dll", "uxtheme.dll", "vac.dll", "van.dll", "vault.dll", "vaultcds.dll", "vaultcli.dll", "vaultroaming.dll", "vaultsvc.dll", "vbsapi.dll", "vbscript.dll", "vbssysprep.dll", "vcardparser.dll", "vdsbas.dll", "vdsdyn.dll", "vdsutil.dll", "vdsvd.dll", "vds_ps.dll", "verifier.dll", "vertdll.dll", "vfuprov.dll", "vfwwdm32.dll", "vhfum.dll", "vid.dll", "videohandlers.dll", "vidreszr.dll", "virtdisk.dll", "vmbuspipe.dll", "vmdevicehost.dll", "vmictimeprovider.dll", "vmrdvcore.dll", "voiprt.dll", "vpnike.dll", "vpnikeapi.dll", "vpnsohdesktop.dll", "vpnv2csp.dll", "vscmgrps.dll", "vssapi.dll", "vsstrace.dll", "vss_ps.dll", "w32time.dll", "w32topl.dll", "waasassessment.dll", "waasmediccapsule.dll", "waasmedicps.dll", "waasmedicsvc.dll", "wabsyncprovider.dll", "walletproxy.dll", "walletservice.dll", "wavemsp.dll", "wbemcomn.dll", "wbiosrvc.dll", "wci.dll", "wcimage.dll", "wcmapi.dll", "wcmcsp.dll", "wcmsvc.dll", "wcnapi.dll", "wcncsvc.dll", "wcneapauthproxy.dll", "wcneappeerproxy.dll", "wcnnetsh.dll", "wcnwiz.dll", "wc_storage.dll", "wdc.dll", "wdi.dll", "wdigest.dll", "wdscore.dll", "webauthn.dll", "webcamui.dll", "webcheck.dll", "webclnt.dll", "webio.dll", "webservices.dll", "websocket.dll", "wecapi.dll", "wecsvc.dll", "wephostsvc.dll", "wer.dll", "werconcpl.dll", "wercplsupport.dll", "werenc.dll", "weretw.dll", "wersvc.dll", "werui.dll", "wevtapi.dll", "wevtfwd.dll", "wevtsvc.dll", "wfapigp.dll", "wfdprov.dll", "wfdsconmgr.dll", "wfdsconmgrsvc.dll", "wfhc.dll", "whealogr.dll", "whhelper.dll", "wiaaut.dll", "wiadefui.dll", "wiadss.dll", "wiarpc.dll", "wiascanprofiles.dll", "wiaservc.dll", "wiashext.dll", "wiatrace.dll", "wificloudstore.dll", "wificonfigsp.dll", "wifidisplay.dll", "wimgapi.dll", "win32spl.dll", "win32u.dll", "winbio.dll", "winbiodatamodel.dll", "winbioext.dll", "winbrand.dll", "wincorlib.dll", "wincredprovider.dll", "wincredui.dll", "windowmanagement.dll", "windowscodecs.dll", "windowscodecsext.dll", "windowscodecsraw.dll", "windowsiotcsp.dll", "windowslivelogin.dll", "winethc.dll", "winhttp.dll", "winhttpcom.dll", "winhvemulation.dll", "winhvplatform.dll", "wininet.dll", "wininetlui.dll", "wininitext.dll", "winipcfile.dll", "winipcsecproc.dll", "winipsec.dll", "winlangdb.dll", "winlogonext.dll", "winmde.dll", "winml.dll", "winmm.dll", "winmmbase.dll", "winmsipc.dll", "winnlsres.dll", "winnsi.dll", "winreagent.dll", "winrnr.dll", "winrscmd.dll", "winrsmgr.dll", "winrssrv.dll", "winrttracing.dll", "winsatapi.dll", "winscard.dll", "winsetupui.dll", "winshfhc.dll", "winsku.dll", "winsockhc.dll", "winsqlite3.dll", "winsrpc.dll", "winsrv.dll", "winsrvext.dll", "winsta.dll", "winsync.dll", "winsyncmetastore.dll", "winsyncproviders.dll", "wintrust.dll", "wintypes.dll", "winusb.dll", "wirednetworkcsp.dll", "wisp.dll", "wkscli.dll", "wkspbrokerax.dll", "wksprtps.dll", "wkssvc.dll", "wlanapi.dll", "wlancfg.dll", "wlanconn.dll", "wlandlg.dll", "wlangpui.dll", "wlanhc.dll", "wlanhlp.dll", "wlanmediamanager.dll", "wlanmm.dll", "wlanmsm.dll", "wlanpref.dll", "wlanradiomanager.dll", "wlansec.dll", "wlansvc.dll", "wlansvcpal.dll", "wlanui.dll", "wlanutil.dll", "wldap32.dll", "wldp.dll", "wlgpclnt.dll", "wlidcli.dll", "wlidcredprov.dll", "wlidfdp.dll", "wlidnsp.dll", "wlidprov.dll", "wlidres.dll", "wlidsvc.dll", "wmadmod.dll", "wmadmoe.dll", "wmalfxgfxdsp.dll", "wmasf.dll", "wmcodecdspps.dll", "wmdmlog.dll", "wmdmps.dll", "wmdrmsdk.dll", "wmerror.dll", "wmi.dll", "wmiclnt.dll", "wmicmiplugin.dll", "wmidcom.dll", "wmidx.dll", "wmiprop.dll", "wmitomi.dll", "wmnetmgr.dll", "wmp.dll", "wmpdui.dll", "wmpdxm.dll", "wmpeffects.dll", "wmphoto.dll", "wmploc.dll", "wmpps.dll", "wmpshell.dll", "wmsgapi.dll", "wmspdmod.dll", "wmspdmoe.dll", "wmvcore.dll", "wmvdecod.dll", "wmvdspa.dll", "wmvencod.dll", "wmvsdecd.dll", "wmvsencd.dll", "wmvxencd.dll", "woftasks.dll", "wofutil.dll", "wordbreakers.dll", "workfoldersgpext.dll", "workfoldersres.dll", "workfoldersshell.dll", "workfolderssvc.dll", "wosc.dll", "wow64.dll", "wow64cpu.dll", "wow64win.dll", "wpbcreds.dll", "wpc.dll", "wpcapi.dll", "wpcdesktopmonsvc.dll", "wpcproxystubs.dll", "wpcrefreshtask.dll", "wpcwebfilter.dll", "wpdbusenum.dll", "wpdshext.dll", "wpdshserviceobj.dll", "wpdsp.dll", "wpd_ci.dll", "wpnapps.dll", "wpnclient.dll", "wpncore.dll", "wpninprc.dll", "wpnprv.dll", "wpnservice.dll", "wpnsruprov.dll", "wpnuserservice.dll", "wpportinglibrary.dll", "wpprecorderum.dll", "wptaskscheduler.dll", "wpx.dll", "ws2help.dll", "ws2_32.dll", "wscapi.dll", "wscinterop.dll", "wscisvif.dll", "wsclient.dll", "wscproxystub.dll", "wscsvc.dll", "wsdapi.dll", "wsdchngr.dll", "wsdprintproxy.dll", "wsdproviderutil.dll", "wsdscanproxy.dll", "wsecedit.dll", "wsepno.dll", "wshbth.dll", "wshcon.dll", "wshelper.dll", "wshext.dll", "wshhyperv.dll", "wship6.dll", "wshqos.dll", "wshrm.dll", "wshtcpip.dll", "wshunix.dll", "wslapi.dll", "wsmagent.dll", "wsmauto.dll", "wsmplpxy.dll", "wsmres.dll", "wsmsvc.dll", "wsmwmipl.dll", "wsnmp32.dll", "wsock32.dll", "wsplib.dll", "wsp_fs.dll", "wsp_health.dll", "wsp_sr.dll", "wtsapi32.dll", "wuapi.dll", "wuaueng.dll", "wuceffects.dll", "wudfcoinstaller.dll", "wudfplatform.dll", "wudfsmcclassext.dll", "wudfx.dll", "wudfx02000.dll", "wudriver.dll", "wups.dll", "wups2.dll", "wuuhext.dll", "wuuhosdeployment.dll", "wvc.dll", "wwaapi.dll", "wwaext.dll", "wwanapi.dll", "wwancfg.dll", "wwanhc.dll", "wwanprotdim.dll", "wwanradiomanager.dll", "wwansvc.dll", "wwapi.dll", "xamltilerender.dll", "xaudio2_8.dll", "xaudio2_9.dll", "xblauthmanager.dll", "xblgamesave.dll", "xblgamesaveext.dll", "xblgamesaveproxy.dll", "xboxgipsvc.dll", "xboxgipsynthetic.dll", "xboxnetapisvc.dll", "xinput1_4.dll", "xinput9_1_0.dll", "xinputuap.dll", "xmlfilter.dll", "xmllite.dll", "xmlprovi.dll", "xolehlp.dll", "xpsgdiconverter.dll", "xpsprint.dll", "xpspushlayer.dll", "xpsrasterservice.dll", "xpsservices.dll", "xwizards.dll", "xwreg.dll", "xwtpdui.dll", "xwtpw32.dll", "zipcontainer.dll", "zipfldr.dll", "bootsvc.dll", "halextintcpsedma.dll", "icsvcvss.dll", "ieproxydesktop.dll", "lsaadt.dll", "nlansp_c.dll", "nrtapi.dll", "opencl.dll", "pfclient.dll", "pnpdiag.dll", "prxyqry.dll", "rdpnanotransport.dll", "servicingcommon.dll", "sortwindows63.dll", "sstpcfg.dll", "tdhres.dll", "umpodev.dll", "utcapi.dll", "windlp.dll", "wow64base.dll", "wow64con.dll", "blbuires.dll", "bpainst.dll", "cbclient.dll", "certadm.dll", "certocm.dll", "certpick.dll", "csdeployres.dll", "dsdeployres.dll", "eapa3hst.dll", "eapacfg.dll", "eapahost.dll", "elsext.dll", "encdump.dll", "escmigplugin.dll", "fsclient.dll", "fsdeployres.dll", "fssminst.dll", "fssmres.dll", "fssprov.dll", "ipamapi.dll", "kpssvc.dll", "lbfoadminlib.dll", "mintdh.dll", "mmci.dll", "mmcico.dll", "mprsnap.dll", "mstsmhst.dll", "mstsmmc.dll", "muxinst.dll", "personax.dll", "rassfm.dll", "rasuser.dll", "rdmsinst.dll", "rdmsres.dll", "rtrfiltr.dll", "sacsvr.dll", "scrdenrl.dll", "sdclient.dll", "sharedstartmodel.dll", "smsrouter.dll", "spwizimg_svr.dll", "sqlcecompact40.dll", "sqlceoledb40.dll", "sqlceqp40.dll", "sqlcese40.dll", "srvmgrinst.dll", "svrmgrnc.dll", "tapisnap.dll", "tlsbrand.dll", "tsec.dll", "tsprop.dll", "tspubiconhelper.dll", "tssdjet.dll", "tsuserex.dll", "ualapi.dll", "ualsvc.dll", "umcres.dll", "updatehandlers.dll", "usocore.dll", "vssui.dll", "wsbappres.dll", "wsbonline.dll", "wsmselpl.dll", "wsmselrr.dll", "xpsfilt.dll", "xpsshhdr.dll"
    ) and
    not (
      (
        dll.name : "icuuc.dll" and dll.code_signature.subject_name in (
          "Valve", "Valve Corp.", "Avanquest Software (7270356 Canada Inc)", "Adobe Inc."
        ) and dll.code_signature.trusted == true
      ) or
      (
        dll.name : ("timeSync.dll", "appInfo.dll") and dll.code_signature.subject_name in (
          "VMware Inc.", "VMware, Inc."
        ) and dll.code_signature.trusted == true
      ) or
      (
        dll.name : "libcrypto.dll" and dll.code_signature.subject_name in (
          "NoMachine S.a.r.l.", "Oculus VR, LLC"
        ) and dll.code_signature.trusted == true
      ) or
      (
        dll.name : "ucrtbase.dll" and dll.code_signature.subject_name in (
          "Proofpoint, Inc.", "Rapid7 LLC", "Eclipse.org Foundation, Inc.", "Amazon.com Services LLC", "Windows Phone"
        ) and dll.code_signature.trusted == true
      ) or
      (
        dll.name : ("libcrypto.dll", "wmi.dll", "geolocation.dll", "kerberos.dll") and
        dll.code_signature.subject_name == "Bitdefender SRL" and dll.code_signature.trusted == true
      ) or
      (dll.name : "ICMP.dll" and dll.code_signature.subject_name == "Paessler AG" and dll.code_signature.trusted == true) or
      (dll.name : "dbghelp.dll" and dll.code_signature.trusted == true) or
      (dll.name : "DirectML.dll" and dll.code_signature.subject_name == "Adobe Inc." and dll.code_signature.trusted == true) or
      (dll.name : "icsvc.dll" and dll.code_signature.subject_name in ("Dell Inc", "Dell Technologies Inc.") and dll.code_signature.trusted == true) or
      (dll.name : "offreg.dll" and dll.code_signature.subject_name == "Malwarebytes Inc." and dll.code_signature.trusted == true) or
      (dll.name : "AppMgr.dll" and dll.code_signature.subject_name == "Autodesk, Inc" and dll.code_signature.trusted == true) or
      (dll.name : ("SsShim.dll", "Msi.dll", "wdscore.dll") and process.name : "DismHost.exe" and dll.path : "C:\\Windows\\Temp\\*") or
      (
        dll.path : (
          "?:\\Windows\\SystemApps\\*\\dxgi.dll",
          "?:\\Windows\\SystemApps\\*\\wincorlib.dll",
          "?:\\Windows\\dxgi.dll",
          "?:\\Users\\*\\AppData\\Local\\LINE\\bin\\current\\dbghelp.dll"
        )
      )
    )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Masquerading
- Id: T1036
- Reference URL: [[https://attack.mitre.org/techniques/T1036/](https://attack.mitre.org/techniques/T1036/)](https://attack.mitre.org/techniques/T1036/)
- Sub Technique:
  - Name: Invalid Code Signature
- Id: T1036.001
- Reference URL: [[https://attack.mitre.org/techniques/T1036/001/](https://attack.mitre.org/techniques/T1036/001/)](https://attack.mitre.org/techniques/T1036/001/)
- Sub Technique:
  - Name: Match Legitimate Resource Name or Location
- Id: T1036.005
- Reference URL: [[https://attack.mitre.org/techniques/T1036/005/](https://attack.mitre.org/techniques/T1036/005/)](https://attack.mitre.org/techniques/T1036/005/)
- Technique:
  - Name: Hijack Execution Flow
- Id: T1574
- Reference URL: [[https://attack.mitre.org/techniques/T1574/](https://attack.mitre.org/techniques/T1574/)](https://attack.mitre.org/techniques/T1574/)
- Sub Technique:
  - Name: DLL
- Id: T1574.001
- Reference URL: [[https://attack.mitre.org/techniques/T1574/001/](https://attack.mitre.org/techniques/T1574/001/)](https://attack.mitre.org/techniques/T1574/001/)
- Sub Technique:
  - Name: DLL
- Id: T1574.001
- Reference URL: [[https://attack.mitre.org/techniques/T1574/001/](https://attack.mitre.org/techniques/T1574/001/)](https://attack.mitre.org/techniques/T1574/001/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Compromise Host Software Binary
- Id: T1554
- Reference URL: [[https://attack.mitre.org/techniques/T1554/](https://attack.mitre.org/techniques/T1554/)](https://attack.mitre.org/techniques/T1554/)