﻿---
title: Potential Masquerading as Browser Process
description: Identifies suspicious instances of browser processes, such as unsigned or signed with unusual certificates, that can indicate an attempt to conceal malicious...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_masquerading_browsers
products:
  - Elastic Security
---

# Potential Masquerading as Browser Process
Identifies suspicious instances of browser processes, such as unsigned or signed with unusual certificates, that can
indicate an attempt to conceal malicious activity, bypass security features such as allowlists, or trick users into
executing malware.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.process-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Tactic: Persistence
- Rule Type: BBR
- Data Source: Elastic Defend

**Version**: 9
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```eql
process where host.os.type == "windows" and event.type == "start" and
  (
    /* Chrome Related Processes */
    (
      process.name : (
        "chrome.exe", "GoogleUpdate.exe", "GoogleCrashHandler64.exe", "GoogleCrashHandler.exe",
        "GoogleUpdateComRegisterShell64.exe", "GoogleUpdateSetup.exe", "GoogleUpdateOnDemand.exe",
        "chrome_proxy.exe", "remote_assistance_host.exe", "remoting_native_messaging_host.exe",
        "GoogleUpdateBroker.exe"
      ) and
      not (process.code_signature.subject_name in ("Google LLC", "Google Inc") and process.code_signature.trusted == true) and
      not (
        process.executable : (
          "?:\\Program Files\\HP\\Sure Click\\servers\\chrome.exe",
          "?:\\Program Files\\HP\\Sure Click\\*\\servers\\chrome.exe"
        ) and
        process.code_signature.subject_name == "Bromium, Inc." and process.code_signature.trusted == true
      ) and
      not (
        process.executable : "?:\\Program Files\\dynatrace\\synthetic\\Chrome-bin\\chrome.exe" and
        process.code_signature.subject_name == "Dynatrace LLC" and process.code_signature.trusted == true
      ) and
      not (
        process.executable : "?:\\Users\\*\\Desktop\\CentBrowser\\chrome.exe" and
        process.code_signature.subject_name == "MV INFORMATICA NORDESTE LTDA" and process.code_signature.trusted == true
      ) and
      not (
        process.executable : (
          "?:\\Users\\*\\AppData\\Local\\ms-playwright\\chromium-*\\chrome-win\\chrome.exe",
          "?:\\Users\\*\\AppData\\Local\\Programs\\synthetics-recorder\\resources\\local-browsers\\chromium-*\\chrome-win\\chrome.exe",
          "*\\node_modules\\puppeteer\\*\\win64-*\\chrome-win\\chrome.exe",
          "?:\\Program Files (x86)\\Invicti Professional Edition\\chromium\\chrome.exe",
          "?:\\Program Files\\End2End, Inc\\ARMS Html Engine\\chrome.exe",
          "?:\\Users\\*\\AppData\\Local\\*BurpSuitePro\\burpbrowser\\*\\chrome.exe",
          "?:\\Users\\*\\AppData\\Roaming\\*BurpSuite\\burpbrowser\\*\\chrome.exe",
          "?:\\Gradient\\Connector.Service\\runtimes\\win-x64\\native\\chrome.exe",
          "?:\\Program Files (x86)\\Netsparker Enterprise Agent-?\\chromium\\chrome.exe"
        ) and process.args: (
                "--enable-features=NetworkService,NetworkServiceInProcess",
                "--type=crashpad-handler", "--enable-automation", "--disable-xss-auditor"
              )
      )
    ) or

    /* MS Edge Related Processes */
    (
      process.name : (
        "msedge.exe", "MicrosoftEdgeUpdate.exe", "identity_helper.exe", "msedgewebview2.exe",
        "MicrosoftEdgeWebview2Setup.exe", "MicrosoftEdge_X*.exe", "msedge_proxy.exe",
        "MicrosoftEdgeUpdateCore.exe", "MicrosoftEdgeUpdateBroker.exe", "MicrosoftEdgeUpdateSetup_X*.exe",
        "MicrosoftEdgeUpdateComRegisterShell64.exe", "msedgerecovery.exe", "MicrosoftEdgeUpdateSetup.exe"
      ) and
      not (process.code_signature.subject_name == "Microsoft Corporation" and process.code_signature.trusted == true) and
      not (
        process.name : "msedgewebview2.exe" and
        process.code_signature.subject_name in ("Bromium, Inc.", "Amazon.com Services LLC", "Code Systems Corporation") and
        process.code_signature.trusted == true
      ) and
      not process.executable : "?:\\Program Files (x86)\\Microsoft\\EdgeUpdate\\MicrosoftEdgeUpdate.exe"
    ) or

    /* Brave Related Processes */
    (
      process.name : (
        "brave.exe", "BraveUpdate.exe", "BraveCrashHandler64.exe", "BraveCrashHandler.exe",
        "BraveUpdateOnDemand.exe", "brave_vpn_helper.exe", "BraveUpdateSetup*.exe",
        "BraveUpdateComRegisterShell64.exe"
      ) and
      not (process.code_signature.subject_name in ("Brave Software, Inc.", "Google Inc") and process.code_signature.trusted == true)
    ) or

    /* Firefox Related Processes */
    (
      process.name : (
        "firefox.exe", "pingsender.exe", "default-browser-agent.exe", "maintenanceservice.exe",
        "plugin-container.exe", "maintenanceservice_tmp.exe", "maintenanceservice_installer.exe",
        "minidump-analyzer.exe"
      ) and
      not (process.code_signature.subject_name == "Mozilla Corporation" and process.code_signature.trusted == true) and
      not (
        process.name : "default-browser-agent.exe" and
        process.code_signature.subject_name in ("WATERFOX LIMITED") and process.code_signature.trusted == true
      ) and
      not process.hash.sha256 == "ddc7a6c3a4b50d23daffe8e364c575fd7df9af9711b14d153b09553ddd3670a0" and
      not process.executable : "?:\\Users\\*\\AppData\\Local\\ms-playwright\\firefox-*\\firefox\\firefox.exe"
    ) or

    /* Island Related Processes */
    (
      process.name : (
        "Island.exe", "IslandUpdate.exe", "IslandCrashHandler.exe", "IslandCrashHandler64.exe",
        "IslandUpdateBroker.exe", "IslandUpdateOnDemand.exe", "IslandUpdateComRegisterShell64.exe",
        "IslandUpdateSetup.exe"
      ) and
      not (process.code_signature.subject_name == "Island Technology Inc." and process.code_signature.trusted == true)
    ) or

    /* Opera Related Processes */
    (
      process.name : ("opera.exe", "opera_*.exe", "browser_assistant.exe") and
      not (process.code_signature.subject_name in ("Opera Norway AS", "Opera Software AS") and process.code_signature.trusted == true)
    ) or

    /* Whale Related Processes */
    (
      process.name : ("whale.exe", "whale_update.exe", "wusvc.exe") and
      not (process.code_signature.subject_name == "NAVER Corp." and process.code_signature.trusted == true)
    ) or

    /* Chromium-based Browsers processes */
    (
      process.name : ("chrmstp.exe", "notification_helper.exe", "elevation_service.exe") and
      not (
        process.code_signature.subject_name in (
          "Island Technology Inc.",
          "Citrix Systems, Inc.",
          "Brave Software, Inc.",
          "Google LLC",
          "Google Inc",
          "Microsoft Corporation",
          "NAVER Corp.",
          "AVG Technologies USA, LLC",
          "Avast Software s.r.o.",
          "PIRIFORM SOFTWARE LIMITED",
          "NortonLifeLock Inc.",
          "Opera Norway AS"
        ) and process.code_signature.trusted == true
      )
    )
  )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Masquerading
- Id: T1036
- Reference URL: [[https://attack.mitre.org/techniques/T1036/](https://attack.mitre.org/techniques/T1036/)](https://attack.mitre.org/techniques/T1036/)
- Sub Technique:
  - Name: Invalid Code Signature
- Id: T1036.001
- Reference URL: [[https://attack.mitre.org/techniques/T1036/001/](https://attack.mitre.org/techniques/T1036/001/)](https://attack.mitre.org/techniques/T1036/001/)
- Sub Technique:
  - Name: Match Legitimate Resource Name or Location
- Id: T1036.005
- Reference URL: [[https://attack.mitre.org/techniques/T1036/005/](https://attack.mitre.org/techniques/T1036/005/)](https://attack.mitre.org/techniques/T1036/005/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Compromise Host Software Binary
- Id: T1554
- Reference URL: [[https://attack.mitre.org/techniques/T1554/](https://attack.mitre.org/techniques/T1554/)](https://attack.mitre.org/techniques/T1554/)