﻿---
title: Image Loaded with Invalid Signature
description: Identifies binaries that are loaded and with an invalid code signature. This may indicate an attempt to masquerade as a signed binary. Rule type: eql...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_invalid_codesign_imageload
products:
  - Elastic Security
---

# Image Loaded with Invalid Signature
Identifies binaries that are loaded and with an invalid code signature. This may indicate an attempt to masquerade as a
signed binary.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.library-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 60m
**Searches indices from**: `now-119m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Rule Type: BBR
- Data Source: Elastic Defend

**Version**: 4
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```eql
library where host.os.type == "windows" and event.action == "load" and
  dll.code_signature.status : ("errorUntrustedRoot", "errorBadDigest", "errorUntrustedRoot") and
  (dll.Ext.relative_file_creation_time <= 500 or dll.Ext.relative_file_name_modify_time <= 500) and
  not startswith~(dll.name, process.name) and
  not dll.path : (
    "?:\\Windows\\System32\\DriverStore\\FileRepository\\*"
  )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Masquerading
- Id: T1036
- Reference URL: [[https://attack.mitre.org/techniques/T1036/](https://attack.mitre.org/techniques/T1036/)](https://attack.mitre.org/techniques/T1036/)
- Sub Technique:
  - Name: Invalid Code Signature
- Id: T1036.001
- Reference URL: [[https://attack.mitre.org/techniques/T1036/001/](https://attack.mitre.org/techniques/T1036/001/)](https://attack.mitre.org/techniques/T1036/001/)