﻿---
title: Indirect Command Execution via Forfiles/Pcalua
description: Identifies indirect command execution via Program Compatibility Assistant (pcalua.exe) or forfiles.exe. Rule type: eql Rule indices: endgame-*, logs-endpoint.events.process-*,...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_indirect_command_exec_pcalua_forfiles
products:
  - Elastic Security
---

# Indirect Command Execution via Forfiles/Pcalua
Identifies indirect command execution via Program Compatibility Assistant (pcalua.exe) or forfiles.exe.
**Rule type**: eql
**Rule indices**:
- endgame-*
- logs-endpoint.events.process-*
- logs-system.security*
- logs-windows.*
- winlogbeat-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 60m
**Searches indices from**: `now-119m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Data Source: Elastic Defend
- Rule Type: BBR
- Data Source: Elastic Endgame
- Data Source: Windows Security Event Logs

**Version**: 107
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```eql
process where host.os.type == "windows" and event.type == "start" and
  process.parent.name : ("pcalua.exe", "forfiles.exe")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Indirect Command Execution
- Id: T1202
- Reference URL: [[https://attack.mitre.org/techniques/T1202/](https://attack.mitre.org/techniques/T1202/)](https://attack.mitre.org/techniques/T1202/)