﻿---
title: File with Suspicious Extension Downloaded
description: Identifies unusual files downloaded from outside the local network that have the potential to be abused for code execution. Rule type: eql Rule indices:...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_download_susp_extension
products:
  - Elastic Security
---

# File with Suspicious Extension Downloaded
Identifies unusual files downloaded from outside the local network that have the potential to be abused for code
execution.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.file-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 60m
**Searches indices from**: `now-119m`
**Maximum alerts per execution**: 100
**References**:
- [[https://x.com/Laughing_Mantis/status/1518766501385318406](https://x.com/Laughing_Mantis/status/1518766501385318406)](https://x.com/Laughing_Mantis/status/1518766501385318406)
- [[https://wikileaks.org/ciav7p1/cms/page_13763375.html](https://wikileaks.org/ciav7p1/cms/page_13763375.html)](https://wikileaks.org/ciav7p1/cms/page_13763375.html)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Data Source: Elastic Defend
- Rule Type: BBR

**Version**: 5
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```eql
file where host.os.type == "windows" and event.type == "creation" and
  file.extension : (
    "appinstaller", "application", "appx", "appxbundle", "cpl", "diagcab", "diagpkg", "diagcfg", "manifest",
    "msix", "pif", "search-ms", "searchConnector-ms", "settingcontent-ms", "symlink", "theme", "themepack" 
  ) and file.Ext.windows.zone_identifier > 1 and
  not
  (
    (
      file.extension : "msix" and 
      file.path : (
        "?:\\Users\\*\\AppData\\Local\\Temp\\WinGet\\Microsoft.Winget.Source*",
        "?:\\Windows\\system32\\config\\systemprofile\\AppData\\Local\\Microsoft\\WinGet\\State\\defaultState\\Microsoft.PreIndexed.Package\\Microsoft.Winget.Source*"
      )
    ) or
    (
      process.name : "Teams.exe" and process.code_signature.trusted == true and
      file.extension : "msix" and 
      file.path : "?:\\Users\\*\\AppData\\Roaming\\Microsoft\\Teams\\tmp\\*"
    )
  )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: System Binary Proxy Execution
- Id: T1218
- Reference URL: [[https://attack.mitre.org/techniques/T1218/](https://attack.mitre.org/techniques/T1218/)](https://attack.mitre.org/techniques/T1218/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Initial Access
- Id: TA0001
- Reference URL: [[https://attack.mitre.org/tactics/TA0001/](https://attack.mitre.org/tactics/TA0001/)](https://attack.mitre.org/tactics/TA0001/)
- Technique:
  - Name: Phishing
- Id: T1566
- Reference URL: [[https://attack.mitre.org/techniques/T1566/](https://attack.mitre.org/techniques/T1566/)](https://attack.mitre.org/techniques/T1566/)
- Sub Technique:
  - Name: Spearphishing Attachment
- Id: T1566.001
- Reference URL: [[https://attack.mitre.org/techniques/T1566/001/](https://attack.mitre.org/techniques/T1566/001/)](https://attack.mitre.org/techniques/T1566/001/)
- Sub Technique:
  - Name: Spearphishing Link
- Id: T1566.002
- Reference URL: [[https://attack.mitre.org/techniques/T1566/002/](https://attack.mitre.org/techniques/T1566/002/)](https://attack.mitre.org/techniques/T1566/002/)