﻿---
title: Execution via Microsoft DotNet ClickOnce Host
description: Identifies the execution of DotNet ClickOnce installer via Dfsvc.exe trampoline. Adversaries may take advantage of ClickOnce to proxy execution of malicious...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_dotnet_clickonce_dfsvc_netcon
products:
  - Elastic Security
---

# Execution via Microsoft DotNet ClickOnce Host
Identifies the execution of DotNet ClickOnce installer via Dfsvc.exe trampoline. Adversaries may take advantage of
ClickOnce to proxy execution of malicious payloads via trusted Microsoft processes.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 60m
**Searches indices from**: `now-119m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Rule Type: BBR
- Data Source: Elastic Defend

**Version**: 3
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```eql
sequence by user.id with maxspan=5s
 [process where host.os.type == "windows" and event.action == "start" and
  process.name : "rundll32.exe" and process.command_line : ("*dfshim*ShOpenVerbApplication*", "*dfshim*#*")]
 [network where host.os.type == "windows" and process.name : "dfsvc.exe"]
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Trusted Developer Utilities Proxy Execution
- Id: T1127
- Reference URL: [[https://attack.mitre.org/techniques/T1127/](https://attack.mitre.org/techniques/T1127/)](https://attack.mitre.org/techniques/T1127/)
- Technique:
  - Name: System Binary Proxy Execution
- Id: T1218
- Reference URL: [[https://attack.mitre.org/techniques/T1218/](https://attack.mitre.org/techniques/T1218/)](https://attack.mitre.org/techniques/T1218/)
- Sub Technique:
  - Name: Rundll32
- Id: T1218.011
- Reference URL: [[https://attack.mitre.org/techniques/T1218/011/](https://attack.mitre.org/techniques/T1218/011/)](https://attack.mitre.org/techniques/T1218/011/)