﻿---
title: Potential Defense Evasion via CMSTP.exe
description: The Microsoft Connection Manager Profile Installer (CMSTP.exe) is a command-line program to install Connection Manager service profiles, which accept...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_cmstp_execution
products:
  - Elastic Security
---

# Potential Defense Evasion via CMSTP.exe
The Microsoft Connection Manager Profile Installer (CMSTP.exe) is a command-line program to install Connection Manager
service profiles, which accept installation information file (INF) files. Adversaries may abuse CMSTP to proxy the
execution of malicious code by supplying INF files that contain malicious commands.
**Rule type**: eql
**Rule indices**:
- endgame-*
- logs-endpoint.events.process-*
- logs-system.security*
- logs-windows.sysmon_operational-*
- winlogbeat-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://attack.mitre.org/techniques/T1218/003/](https://attack.mitre.org/techniques/T1218/003/)](https://attack.mitre.org/techniques/T1218/003/)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Data Source: Elastic Defend
- Rule Type: BBR
- Data Source: Sysmon
- Data Source: Elastic Endgame
- Data Source: Windows Security Event Logs

**Version**: 109
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```eql
process where host.os.type == "windows" and event.type == "start" and
  process.name : "cmstp.exe" and process.args == "/s"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: System Binary Proxy Execution
- Id: T1218
- Reference URL: [[https://attack.mitre.org/techniques/T1218/](https://attack.mitre.org/techniques/T1218/)](https://attack.mitre.org/techniques/T1218/)
- Sub Technique:
  - Name: CMSTP
- Id: T1218.003
- Reference URL: [[https://attack.mitre.org/techniques/T1218/003/](https://attack.mitre.org/techniques/T1218/003/)](https://attack.mitre.org/techniques/T1218/003/)