﻿---
title: AWS RDS DB Snapshot Created
description: Identifies when an AWS RDS DB Snapshot is created. This can be used to evade defenses by allowing an attacker to bypass access controls or cover their...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_aws_rds_snapshot_created
products:
  - Elastic Security
---

# AWS RDS DB Snapshot Created
Identifies when an AWS RDS DB Snapshot is created. This can be used to evade defenses by allowing an attacker to bypass access controls
or cover their tracks by reverting an instance to a previous state. This is a [building block
rule](https://www.elastic.co/guide/en/security/current/building-block-rule.html) and does not generate alerts on
its own. It is meant to be used for correlation with other rules to detect suspicious activity. To generate alerts, create a
rule that uses this signal as a building block.
**Rule type**: query
**Rule indices**:
- filebeat-*
- logs-aws.cloudtrail-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 10m
**Searches indices from**: `now-60m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Cloud
- Data Source: AWS
- Data Source: Amazon Web Services
- Data Source: AWS RDS
- Use Case: Asset Visibility
- Tactic: Defense Evasion
- Rule Type: BBR

**Version**: 3
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```kuery
event.dataset: "aws.cloudtrail" and event.provider: "rds.amazonaws.com" 
    and event.action: ("CreateDBSnapshot" or "CreateDBClusterSnapshot") and event.outcome: "success" 
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Modify Cloud Compute Infrastructure
- Id: T1578
- Reference URL: [[https://attack.mitre.org/techniques/T1578/](https://attack.mitre.org/techniques/T1578/)](https://attack.mitre.org/techniques/T1578/)
- Sub Technique:
  - Name: Create Snapshot
- Id: T1578.001
- Reference URL: [[https://attack.mitre.org/techniques/T1578/001/](https://attack.mitre.org/techniques/T1578/001/)](https://attack.mitre.org/techniques/T1578/001/)