﻿---
title: Memory Dump File with Unusual Extension
description: Identifies the creation of a memory dump file with an unusual extension, which can indicate an attempt to disguise a memory dump as another file type...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/credential_access_mdmp_file_unusual_extension
products:
  - Elastic Security
---

# Memory Dump File with Unusual Extension
Identifies the creation of a memory dump file with an unusual extension, which can indicate an attempt to disguise a
memory dump as another file type to bypass security defenses.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.file-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Credential Access
- Tactic: Defense Evasion
- Data Source: Elastic Defend
- Rule Type: BBR

**Version**: 4
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```eql
file where host.os.type == "windows" and event.type == "creation" and

  /* MDMP header */
  file.Ext.header_bytes : "4d444d50*" and
  not file.extension : ("dmp", "mdmp", "hdmp", "edmp", "full", "tdref", "cg", "tmp", "dat") and
  not 
  (
    process.executable : "?:\\Program Files\\Endgame\\esensor.exe" and
    process.code_signature.trusted == true and length(file.extension) == 0
  ) and
  not
  (
    process.name : "System" and file.extension : "tmpscan"
  )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: OS Credential Dumping
- Id: T1003
- Reference URL: [[https://attack.mitre.org/techniques/T1003/](https://attack.mitre.org/techniques/T1003/)](https://attack.mitre.org/techniques/T1003/)
- Sub Technique:
  - Name: LSASS Memory
- Id: T1003.001
- Reference URL: [[https://attack.mitre.org/techniques/T1003/001/](https://attack.mitre.org/techniques/T1003/001/)](https://attack.mitre.org/techniques/T1003/001/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Masquerading
- Id: T1036
- Reference URL: [[https://attack.mitre.org/techniques/T1036/](https://attack.mitre.org/techniques/T1036/)](https://attack.mitre.org/techniques/T1036/)
- Sub Technique:
  - Name: Masquerade File Type
- Id: T1036.008
- Reference URL: [[https://attack.mitre.org/techniques/T1036/008/](https://attack.mitre.org/techniques/T1036/008/)](https://attack.mitre.org/techniques/T1036/008/)