﻿---
title: Microsoft IIS Service Account Password Dumped
description: Identifies the Internet Information Services (IIS) command-line tool, AppCmd, being used to list passwords. An attacker with IIS web server access via...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/credential_access_iis_apppoolsa_pwd_appcmd
products:
  - Elastic Security
---

# Microsoft IIS Service Account Password Dumped
Identifies the Internet Information Services (IIS) command-line tool, AppCmd, being used to list passwords. An attacker
with IIS web server access via a web shell can decrypt and dump the IIS AppPool service account password using AppCmd.
**Rule type**: eql
**Rule indices**:
- endgame-*
- logs-endpoint.events.process-*
- logs-system.security*
- logs-windows.*
- winlogbeat-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://blog.netspi.com/decrypting-iis-passwords-to-break-out-of-the-dmz-part-1/](https://blog.netspi.com/decrypting-iis-passwords-to-break-out-of-the-dmz-part-1/)](https://blog.netspi.com/decrypting-iis-passwords-to-break-out-of-the-dmz-part-1/)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Credential Access
- Data Source: Elastic Endgame
- Data Source: Elastic Defend
- Rule Type: BBR
- Data Source: Windows Security Event Logs

**Version**: 217
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```eql
process where host.os.type == "windows" and event.type == "start" and
   (process.name : "appcmd.exe" or ?process.pe.original_file_name == "appcmd.exe") and
   process.args : "list" and process.args : "/text*"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: OS Credential Dumping
- Id: T1003
- Reference URL: [[https://attack.mitre.org/techniques/T1003/](https://attack.mitre.org/techniques/T1003/)](https://attack.mitre.org/techniques/T1003/)