﻿---
title: Bitsadmin Activity
description: Windows Background Intelligent Transfer Service (BITS) is a low-bandwidth, asynchronous file transfer mechanism. Adversaries may abuse BITS to persist,...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/command_and_control_bitsadmin_activity
products:
  - Elastic Security
---

# Bitsadmin Activity
Windows Background Intelligent Transfer Service (BITS) is a low-bandwidth, asynchronous file transfer mechanism.
Adversaries may abuse BITS to persist, download, execute, and even clean up after running malicious code.
**Rule type**: eql
**Rule indices**:
- endgame-*
- logs-endpoint.events.process-*
- logs-system.security*
- logs-windows.sysmon_operational-*
- winlogbeat-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 60m
**Searches indices from**: `now-119m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Command and Control
- Data Source: Elastic Defend
- Rule Type: BBR
- Data Source: Sysmon
- Data Source: Elastic Endgame
- Data Source: Windows Security Event Logs

**Version**: 108
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```eql
process where host.os.type == "windows" and event.type == "start" and
  (
   (process.name : "bitsadmin.exe" and process.args : (
        "*Transfer*", "*Create*", "AddFile", "*SetNotifyFlags*", "*SetNotifyCmdLine*",
        "*SetMinRetryDelay*", "*SetCustomHeaders*", "*Resume*")
   ) or
   (process.name : "powershell.exe" and process.args : (
        "*Start-BitsTransfer*", "*Add-BitsFile*",
        "*Resume-BitsTransfer*", "*Set-BitsTransfer*", "*BITS.Manager*")
   )
  )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Command and Control
- Id: TA0011
- Reference URL: [[https://attack.mitre.org/tactics/TA0011/](https://attack.mitre.org/tactics/TA0011/)](https://attack.mitre.org/tactics/TA0011/)
- Technique:
  - Name: Ingress Tool Transfer
- Id: T1105
- Reference URL: [[https://attack.mitre.org/techniques/T1105/](https://attack.mitre.org/techniques/T1105/)](https://attack.mitre.org/techniques/T1105/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: BITS Jobs
- Id: T1197
- Reference URL: [[https://attack.mitre.org/techniques/T1197/](https://attack.mitre.org/techniques/T1197/)](https://attack.mitre.org/techniques/T1197/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: BITS Jobs
- Id: T1197
- Reference URL: [[https://attack.mitre.org/techniques/T1197/](https://attack.mitre.org/techniques/T1197/)](https://attack.mitre.org/techniques/T1197/)