﻿---
title: Accessing Outlook Data Files
description: Identifies commands containing references to Outlook data files extensions, which can potentially indicate the search, access, or modification of these...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/collection_outlook_email_archive
products:
  - Elastic Security
---

# Accessing Outlook Data Files
Identifies commands containing references to Outlook data files extensions, which can potentially indicate the search,
access, or modification of these files.
**Rule type**: eql
**Rule indices**:
- endgame-*
- logs-endpoint.events.process-*
- logs-system.security*
- logs-windows.sysmon_operational-*
- winlogbeat-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 60m
**Searches indices from**: `now-119m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Collection
- Data Source: Elastic Defend
- Rule Type: BBR
- Data Source: Sysmon
- Data Source: Elastic Endgame
- Data Source: Windows Security Event Logs

**Version**: 108
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```eql
process where host.os.type == "windows" and event.type == "start" and process.args : ("*.ost", "*.pst") and
  not process.name : "outlook.exe" and
  not (
        process.name : "rundll32.exe" and
        process.args : "*davclnt.dll,DavSetCookie*"
  )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Collection
- Id: TA0009
- Reference URL: [[https://attack.mitre.org/tactics/TA0009/](https://attack.mitre.org/tactics/TA0009/)](https://attack.mitre.org/tactics/TA0009/)
- Technique:
  - Name: Email Collection
- Id: T1114
- Reference URL: [[https://attack.mitre.org/techniques/T1114/](https://attack.mitre.org/techniques/T1114/)](https://attack.mitre.org/techniques/T1114/)
- Sub Technique:
  - Name: Local Email Collection
- Id: T1114.001
- Reference URL: [[https://attack.mitre.org/techniques/T1114/001/](https://attack.mitre.org/techniques/T1114/001/)](https://attack.mitre.org/techniques/T1114/001/)