﻿---
title: File Staged in Root Folder of Recycle Bin
description: Identifies files written to the root of the Recycle Bin folder instead of subdirectories. Adversaries may place files in the root of the Recycle Bin in...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/collection_files_staged_in_recycle_bin_root
products:
  - Elastic Security
---

# File Staged in Root Folder of Recycle Bin
Identifies files written to the root of the Recycle Bin folder instead of subdirectories. Adversaries may place files in
the root of the Recycle Bin in preparation for exfiltration or to evade defenses.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.file-*
- logs-windows.sysmon_operational-*
- endgame-*
- winlogbeat-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 60m
**Searches indices from**: `now-119m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Collection
- Data Source: Elastic Defend
- Rule Type: BBR
- Data Source: Elastic Endgame
- Data Source: Sysmon

**Version**: 108
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```eql
file where host.os.type == "windows" and event.type == "creation" and
  file.path : "?:\\$RECYCLE.BIN\\*" and
  not file.path : "?:\\$RECYCLE.BIN\\*\\*" and
  not file.name : "desktop.ini"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Collection
- Id: TA0009
- Reference URL: [[https://attack.mitre.org/tactics/TA0009/](https://attack.mitre.org/tactics/TA0009/)](https://attack.mitre.org/tactics/TA0009/)
- Technique:
  - Name: Data Staged
- Id: T1074
- Reference URL: [[https://attack.mitre.org/techniques/T1074/](https://attack.mitre.org/techniques/T1074/)](https://attack.mitre.org/techniques/T1074/)
- Sub Technique:
  - Name: Local Data Staging
- Id: T1074.001
- Reference URL: [[https://attack.mitre.org/techniques/T1074/001/](https://attack.mitre.org/techniques/T1074/001/)](https://attack.mitre.org/techniques/T1074/001/)