﻿---
title: Compression DLL Loaded by Unusual Process
description: Identifies the image load of a compression DLL. Adversaries will often compress and encrypt data in preparation for exfiltration. Rule type: eql Rule...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/collection_archive_data_zip_imageload
products:
  - Elastic Security
---

# Compression DLL Loaded by Unusual Process
Identifies the image load of a compression DLL. Adversaries will often compress and encrypt data in preparation for
exfiltration.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.library-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 60m
**Searches indices from**: `now-119m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Collection
- Data Source: Elastic Defend
- Rule Type: BBR

**Version**: 5
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```eql
library where host.os.type == "windows" and event.action == "load" and
  dll.name : ("System.IO.Compression.FileSystem.ni.dll", "System.IO.Compression.ni.dll") and
  not 
  (
    (
      process.executable : (
        "?:\\Program Files\\*",
        "?:\\Program Files (x86)\\*",
        "?:\\Windows\\Microsoft.NET\\Framework*\\mscorsvw.exe",
        "?:\\Windows\\System32\\sdiagnhost.exe",
        "?:\\Windows\\System32\\inetsrv\\w3wp.exe",
        "?:\\Windows\\SysWOW64\\inetsrv\\w3wp.exe",
        "?:\\ProgramData\\Microsoft\\Windows Defender Advanced Threat Protection\\DataCollection\\*\\OpenHandleCollector.exe"
      ) and process.code_signature.trusted == true
    ) or
    (
      process.name : "NuGet.exe" and process.code_signature.trusted == true and user.id : ("S-1-5-18", "S-1-5-20")
    )
  )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Collection
- Id: TA0009
- Reference URL: [[https://attack.mitre.org/tactics/TA0009/](https://attack.mitre.org/tactics/TA0009/)](https://attack.mitre.org/tactics/TA0009/)
- Technique:
  - Name: Archive Collected Data
- Id: T1560
- Reference URL: [[https://attack.mitre.org/techniques/T1560/](https://attack.mitre.org/techniques/T1560/)](https://attack.mitre.org/techniques/T1560/)