﻿---
title: Process Created with an Elevated Token
description: Identifies the creation of a process running as SYSTEM and impersonating a Windows core binary privileges. Adversaries may create a new process with a...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_via_token_theft
products:
  - Elastic Security
---

# Process Created with an Elevated Token
Identifies the creation of a process running as SYSTEM and impersonating a Windows core binary privileges. Adversaries
may create a new process with a different token to escalate privileges and bypass access controls.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.process-*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://lengjibo.github.io/token/](https://lengjibo.github.io/token/)](https://lengjibo.github.io/token/)
- [[https://docs.microsoft.com/en-us/windows/win32/api/winbase/nf-winbase-createprocesswithtokenw](https://docs.microsoft.com/en-us/windows/win32/api/winbase/nf-winbase-createprocesswithtokenw)](https://docs.microsoft.com/en-us/windows/win32/api/winbase/nf-winbase-createprocesswithtokenw)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Privilege Escalation
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 10
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Process Created with an Elevated Token

In Windows environments, processes can be created with elevated tokens to perform tasks requiring higher privileges. Adversaries exploit this by impersonating system-level binaries to escalate privileges and bypass security controls. The detection rule identifies such activities by monitoring process creation events, focusing on those initiated by privileged binaries and excluding known benign processes. This helps in identifying unauthorized privilege escalation attempts.

### Possible investigation steps

- Review the process creation event details to identify the specific executable and its parent process, focusing on the fields process.executable and process.Ext.effective_parent.executable.
- Check the user.id field to confirm if the process was created with the SYSTEM user ID (S-1-5-18), indicating elevated privileges.
- Investigate the parent process executable path to determine if it matches any known privileged Microsoft native binaries, which could be targets for token theft.
- Examine the process code signature details, especially process.code_signature.trusted and process.code_signature.subject_name, to verify if the executable is signed by a trusted entity or if it matches any excluded signatures.
- Correlate the process creation event with other security logs and alerts to identify any related suspicious activities or patterns that might indicate privilege escalation attempts.
- Assess the context and timing of the event to determine if it aligns with legitimate administrative tasks or if it appears anomalous in the environment.


### False positive analysis

- Utility Manager in Windows running in debug mode can trigger false positives. To handle this, exclude processes where both the effective parent and parent executables are Utilman.exe with the /debug argument.
- Windows print spooler service correlated with Access Intelligent Form may cause false alerts. Exclude processes where the parent executable is spoolsv.exe and the process executable is LaunchCreate.exe under Access Intelligent Form.
- Windows error reporting executables like WerFault.exe can be mistakenly flagged. Exclude these specific executables from the rule to prevent unnecessary alerts.
- Windows updates initiated by TiWorker.exe running with elevated privileges can be misidentified. Exclude processes where TiWorker.exe is the parent and the process executable matches known update-related paths.
- Additional parent executables that typically run with elevated privileges, such as AtBroker.exe and svchost.exe, can lead to false positives. Exclude these parent executables from the rule to reduce noise.
- Trusted Windows binaries with specific signature names, such as those from TeamViewer or Cisco WebEx, may be incorrectly flagged. Exclude processes with a trusted code signature and matching subject names to avoid false alerts.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further unauthorized access or lateral movement by the adversary.
- Terminate any suspicious processes identified by the detection rule that are running with elevated privileges, especially those not matching known benign processes.
- Conduct a thorough review of user accounts and privileges on the affected system to identify and disable any unauthorized accounts or privilege escalations.
- Restore the affected system from a known good backup to ensure any malicious changes are reverted, and verify the integrity of the system post-restoration.
- Implement additional monitoring on the affected system and network to detect any further attempts at privilege escalation or token manipulation.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if the threat has spread to other systems.
- Review and update endpoint protection and detection capabilities to ensure they are configured to detect similar threats in the future, leveraging the MITRE ATT&CK framework for guidance on Access Token Manipulation (T1134).


## Rule Query

```eql
/* This rule is only compatible with Elastic Endpoint 8.4+ */

process where host.os.type == "windows" and event.action == "start" and

 /* CreateProcessWithToken and effective parent is a privileged MS native binary used as a target for token theft */
 user.id == "S-1-5-18"  and process.parent.executable != null and

 /* Token Theft target process usually running as service are located in one of the following paths */
 process.Ext.effective_parent.executable : "?:\\Windows\\*.exe" and

/* Ignores Utility Manager in Windows running in debug mode */
 not (process.Ext.effective_parent.executable : "?:\\Windows\\System32\\Utilman.exe" and
      process.parent.executable : "?:\\Windows\\System32\\Utilman.exe" and process.parent.args : "/debug") and

/* Ignores Windows print spooler service with correlation to Access Intelligent Form */
not (process.parent.executable : ("?\\Windows\\System32\\spoolsv.exe", "C:\\Windows\\System32\\PrintIsolationHost.exe") and
     process.executable: ("?:\\Program Files\\*.exe",
                          "?:\\Program Files (x86)\\*.exe",
                          "?:\\Windows\\System32\\spool\\drivers\\*.exe",
                          "?:\\Windows\\System32\\ROUTE.EXE")) and

/* Ignores Windows error reporting executables */
 not process.executable : ("?:\\Windows\\System32\\WerFault.exe",
                           "?:\\Windows\\SysWOW64\\WerFault.exe",
                           "?:\\Windows\\System32\\WerFaultSecure.exe",
                           "?:\\Windows\\SysWOW64\\WerFaultSecure.exe",
                           "?:\\windows\\system32\\WerMgr.exe",
                           "?:\\Windows\\SoftwareDistribution\\Download\\Install\\securityhealthsetup.exe")  and

 /* Ignores Windows updates from TiWorker.exe that runs with elevated privileges */
 not (process.parent.executable : "?:\\Windows\\WinSxS\\*\\TiWorker.exe" and
      process.executable : ("?:\\Windows\\Microsoft.NET\\Framework*.exe",
                            "?:\\Windows\\WinSxS\\*.exe",
                            "?:\\Windows\\System32\\inetsrv\\iissetup.exe",
                            "?:\\Windows\\SysWOW64\\inetsrv\\iissetup.exe",
                            "?:\\Windows\\System32\\inetsrv\\aspnetca.exe",
                            "?:\\Windows\\SysWOW64\\inetsrv\\aspnetca.exe",
                            "?:\\Windows\\System32\\lodctr.exe",
                            "?:\\Windows\\SysWOW64\\lodctr.exe",
                            "?:\\Windows\\System32\\netcfg.exe",
                            "?:\\Windows\\Microsoft.NET\\Framework*\\*\\ngen.exe",
                            "?:\\Windows\\Microsoft.NET\\Framework*\\*\\aspnet_regiis.exe")) and


/* Ignores additional parent executables that run with elevated privileges */
 not process.parent.executable :
               ("?:\\Windows\\System32\\AtBroker.exe",
                "?:\\Windows\\system32\\svchost.exe",
                "?:\\Program Files (x86)\\*.exe",
                "?:\\Program Files\\*.exe",
                "?:\\Windows\\System32\\msiexec.exe",
                "?:\\Windows\\System32\\DriverStore\\*",
                "?:\\Windows\\LTSvc\\*\\Update.exe") and

/* Ignores Windows binaries with a trusted signature and specific signature name */
 not (process.code_signature.trusted == true and
      process.code_signature.subject_name :
                ("philandro Software GmbH",
                 "Freedom Scientific Inc.",
                 "TeamViewer Germany GmbH",
                 "Projector.is, Inc.",
                 "TeamViewer GmbH",
                 "Cisco WebEx LLC",
                 "Dell Inc",
                 "Sophos Ltd",
                 "Sophos Limited",
                 "Brother Industries, Ltd.",
                 "MILVUS INOVACOES EM SOFTWARE LTDA",
                 "Chocolatey Software, Inc")) and

 not (process.Ext.effective_parent.executable : "?:\\Windows\\servicing\\TrustedInstaller.exe" and
      process.executable : "C:\\Windows\\WinSxS\\amd64_microsoft-windows-servicingstack_*\\TiWorker.exe") and

 not process.Ext.effective_parent.executable : "?:\\Windows\\ServiceProfiles\\LocalService\\AppData\\Local\\ServicePortalAgent\\current\\emulator\\MmrAgent.NetFxEmulator.exe"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Access Token Manipulation
- Id: T1134
- Reference URL: [[https://attack.mitre.org/techniques/T1134/](https://attack.mitre.org/techniques/T1134/)](https://attack.mitre.org/techniques/T1134/)
- Sub Technique:
  - Name: Create Process with Token
- Id: T1134.002
- Reference URL: [[https://attack.mitre.org/techniques/T1134/002/](https://attack.mitre.org/techniques/T1134/002/)](https://attack.mitre.org/techniques/T1134/002/)