﻿---
title: SeDebugPrivilege Enabled by a Suspicious Process
description: Identifies a process running with a non-SYSTEM account that enables the SeDebugPrivilege privilege. Adversaries may enable this privilege to debug and...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_tokenmanip_sedebugpriv_enabled
products:
  - Elastic Security
---

# SeDebugPrivilege Enabled by a Suspicious Process
Identifies a process running with a non-SYSTEM account that enables the SeDebugPrivilege privilege. Adversaries may
enable this privilege to debug and modify other processes, typically reserved for system-level tasks, to escalate
privileges and bypass access controls.
**Rule type**: eql
**Rule indices**:
- logs-system.security*
- logs-windows.forwarded*
- winlogbeat-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://learn.microsoft.com/en-us/windows/security/threat-protection/auditing/event-4703](https://learn.microsoft.com/en-us/windows/security/threat-protection/auditing/event-4703)](https://learn.microsoft.com/en-us/windows/security/threat-protection/auditing/event-4703)
- [[https://blog.palantir.com/windows-privilege-abuse-auditing-detection-and-defense-3078a403d74e](https://blog.palantir.com/windows-privilege-abuse-auditing-detection-and-defense-3078a403d74e)](https://blog.palantir.com/windows-privilege-abuse-auditing-detection-and-defense-3078a403d74e)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Privilege Escalation
- Data Source: Windows Security Event Logs
- Resources: Investigation Guide

**Version**: 113
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

Windows Event 4703 logs Token Privileges changes and need to be configured (Enable).
Steps to implement the logging policy with Advanced Audit Configuration:
```
Computer Configuration >
Policies >
Windows Settings >
Security Settings >
Advanced Audit Policies Configuration >
Audit Policies >
Detailed Tracking >
Token Right Adjusted Events (Success)
```


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating SeDebugPrivilege Enabled by a Suspicious Process

SeDebugPrivilege is a powerful Windows privilege allowing processes to debug and modify other processes, typically reserved for system-level tasks. Adversaries exploit this to escalate privileges, bypassing security controls by impersonating system processes. The detection rule identifies suspicious processes enabling SeDebugPrivilege, excluding known legitimate processes, to flag potential privilege escalation attempts.

### Possible investigation steps

- Review the event logs for the specific event.provider "Microsoft-Windows-Security-Auditing" and event.action "Token Right Adjusted Events" to gather more details about the process that enabled SeDebugPrivilege.
- Identify the process name from winlog.event_data.ProcessName and determine if it is known or expected in the environment. Investigate any unknown or suspicious processes.
- Check the winlog.event_data.SubjectUserSid to identify the user account associated with the process. Investigate if this account has a history of suspicious activity or if it should have the ability to enable SeDebugPrivilege.
- Analyze the parent process of the suspicious process to understand how it was initiated and if it was spawned by a legitimate or malicious process.
- Correlate the timestamp of the event with other security events or alerts to identify any related activities or patterns that could indicate a broader attack or compromise.
- Investigate the network activity of the suspicious process to determine if it is communicating with any known malicious IP addresses or domains.


### False positive analysis

- Legitimate system maintenance tasks may trigger the rule, such as Windows Update or system diagnostics. Users can monitor the timing of these tasks and correlate them with alerts to determine if they are the cause.
- Software installations or updates using msiexec.exe might be flagged. Consider excluding msiexec.exe from the rule if it is frequently used in your environment for legitimate purposes.
- Administrative tools like taskhostw.exe and mmc.exe can sometimes enable SeDebugPrivilege during normal operations. Evaluate the necessity of these tools in your environment and exclude them if they are regularly used by trusted administrators.
- Temporary files created by legitimate applications, such as DismHost.exe in user temp directories, may be flagged. Review the context of these files and exclude them if they are part of routine application behavior.
- Regularly review and update the exclusion list to include any new legitimate processes that are identified as false positives, ensuring the rule remains effective without generating unnecessary alerts.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further unauthorized access or lateral movement by the adversary.
- Terminate the suspicious process identified in the alert to stop any ongoing malicious activity and prevent privilege escalation.
- Conduct a thorough review of the affected system's event logs, focusing on the "Token Right Adjusted Events" to identify any additional unauthorized privilege changes or suspicious activities.
- Reset credentials for any accounts that may have been compromised or used by the suspicious process, especially those with elevated privileges.
- Restore the affected system from a known good backup to ensure any malicious changes are removed and the system is returned to a secure state.
- Implement additional monitoring on the affected system and similar systems to detect any recurrence of the threat, focusing on processes attempting to enable SeDebugPrivilege.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if additional systems are affected.


## Rule Query

```eql
any where host.os.type == "windows" and event.provider: "Microsoft-Windows-Security-Auditing" and
 event.action : "Token Right Adjusted Events" and

 winlog.event_data.EnabledPrivilegeList : "SeDebugPrivilege" and

 /* exclude processes with System Integrity  */
 not winlog.event_data.SubjectUserSid : ("S-1-5-18", "S-1-5-19", "S-1-5-20") and

 not winlog.event_data.ProcessName : (
        "?:\\Program Files (x86)\\*",
        "?:\\Program Files\\*",
        "?:\\Users\\*\\AppData\\Local\\Temp\\*-*\\DismHost.exe",
        "?:\\Windows\\System32\\auditpol.exe",
        "?:\\Windows\\System32\\cleanmgr.exe",
        "?:\\Windows\\System32\\lsass.exe",
        "?:\\Windows\\System32\\mmc.exe",
        "?:\\Windows\\System32\\MRT.exe",
        "?:\\Windows\\System32\\msiexec.exe",
        "?:\\Windows\\System32\\sdiagnhost.exe",
        "?:\\Windows\\System32\\ServerManager.exe",
        "?:\\Windows\\System32\\taskhostw.exe",
        "?:\\Windows\\System32\\wbem\\WmiPrvSe.exe",
        "?:\\Windows\\System32\\WerFault.exe",
        "?:\\Windows\\SysWOW64\\msiexec.exe",
        "?:\\Windows\\SysWOW64\\wbem\\WmiPrvSe.exe",
        "?:\\Windows\\SysWOW64\\WerFault.exe",
        "?:\\Windows\\WinSxS\\*"
    )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Access Token Manipulation
- Id: T1134
- Reference URL: [[https://attack.mitre.org/techniques/T1134/](https://attack.mitre.org/techniques/T1134/)](https://attack.mitre.org/techniques/T1134/)