﻿---
title: Potential Privileged Escalation via SamAccountName Spoofing
description: Identifies a suspicious computer account name rename event, which may indicate an attempt to exploit CVE-2021-42278 to elevate privileges from a standard...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_samaccountname_spoofing_attack
products:
  - Elastic Security
---

# Potential Privileged Escalation via SamAccountName Spoofing
Identifies a suspicious computer account name rename event, which may indicate an attempt to exploit CVE-2021-42278 to
elevate privileges from a standard domain user to a user with domain admin privileges. CVE-2021-42278 is a security
vulnerability that allows potential attackers to impersonate a domain controller via samAccountName attribute spoofing.
**Rule type**: eql
**Rule indices**:
- logs-system.security*
- logs-windows.forwarded*
- winlogbeat-*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://support.microsoft.com/en-us/topic/kb5008102-active-directory-security-accounts-manager-hardening-changes-cve-2021-42278-5975b463-4c95-45e1-831a-d120004e258e](https://support.microsoft.com/en-us/topic/kb5008102-active-directory-security-accounts-manager-hardening-changes-cve-2021-42278-5975b463-4c95-45e1-831a-d120004e258e)](https://support.microsoft.com/en-us/topic/kb5008102-active-directory-security-accounts-manager-hardening-changes-cve-2021-42278-5975b463-4c95-45e1-831a-d120004e258e)
- [[https://cloudbrothers.info/en/exploit-kerberos-samaccountname-spoofing/](https://cloudbrothers.info/en/exploit-kerberos-samaccountname-spoofing/)](https://cloudbrothers.info/en/exploit-kerberos-samaccountname-spoofing/)
- [[https://github.com/cube0x0/noPac](https://github.com/cube0x0/noPac)](https://github.com/cube0x0/noPac)
- [[https://twitter.com/exploitph/status/1469157138928914432](https://twitter.com/exploitph/status/1469157138928914432)](https://twitter.com/exploitph/status/1469157138928914432)
- [[https://exploit.ph/cve-2021-42287-cve-2021-42278-weaponisation.html](https://exploit.ph/cve-2021-42287-cve-2021-42278-weaponisation.html)](https://exploit.ph/cve-2021-42287-cve-2021-42278-weaponisation.html)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Persistence
- Tactic: Privilege Escalation
- Use Case: Active Directory Monitoring
- Data Source: Active Directory
- Use Case: Vulnerability
- Data Source: Windows Security Event Logs
- Resources: Investigation Guide

**Version**: 214
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Potential Privileged Escalation via SamAccountName Spoofing

In Active Directory environments, the samAccountName attribute is crucial for identifying user and computer accounts. Adversaries may exploit vulnerabilities like CVE-2021-42278 to spoof this attribute, potentially elevating privileges by renaming computer accounts to mimic domain controllers. The detection rule identifies suspicious renaming events, where a machine account is altered to resemble a user account, signaling possible privilege escalation attempts.

### Possible investigation steps

- Review the event logs to confirm the occurrence of a "renamed-user-account" action, focusing on entries where the OldTargetUserName ends with a "$" and the NewTargetUserName does not, indicating a potential spoofing attempt.
- Identify the source of the rename event by examining the event logs for the user or system that initiated the change, and determine if it aligns with expected administrative activity.
- Check the history of the NewTargetUserName to see if it has been used in any recent authentication attempts or privileged operations, which could indicate malicious intent.
- Investigate the associated IP address and hostname from which the rename action was performed to determine if it is a known and trusted source within the network.
- Correlate the event with other security alerts or logs to identify any patterns or additional suspicious activities that might suggest a broader attack campaign.
- Assess the potential impact by determining if the renamed account has been granted elevated privileges or access to sensitive resources since the rename event occurred.


### False positive analysis

- Routine administrative tasks involving legitimate renaming of computer accounts can trigger false positives. To manage this, create exceptions for known administrative activities by excluding specific administrator accounts or service accounts from the detection rule.
- Automated processes or scripts that rename computer accounts as part of regular maintenance or deployment procedures may also cause false alerts. Identify these processes and exclude their associated accounts or event patterns from the rule.
- Temporary renaming of computer accounts for troubleshooting or testing purposes can be mistaken for suspicious activity. Document and exclude these temporary changes by maintaining a list of authorized personnel and their activities.
- Changes made by trusted third-party software or management tools that interact with Active Directory should be reviewed and, if deemed safe, excluded from triggering alerts by specifying the tool's account or signature in the rule exceptions.


### Response and remediation

- Immediately isolate the affected machine from the network to prevent further unauthorized access or lateral movement within the domain.
- Revert any unauthorized changes to the samAccountName attribute by renaming the affected computer account back to its original name.
- Conduct a thorough review of recent changes in Active Directory, focusing on user and computer account modifications, to identify any other potentially compromised accounts.
- Reset passwords for the affected machine account and any other accounts that may have been accessed or modified during the incident.
- Apply the latest security patches and updates to all domain controllers and critical systems to mitigate vulnerabilities like CVE-2021-42278.
- Enhance monitoring and logging for Active Directory events, specifically focusing on account renaming activities, to detect similar threats in the future.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to ensure comprehensive remediation efforts are undertaken.


## Rule Query

```eql
iam where host.os.type == "windows" and event.action == "renamed-user-account" and
  /* machine account name renamed to user like account name */
  winlog.event_data.OldTargetUserName : "*$" and not winlog.event_data.NewTargetUserName : "*$"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Exploitation for Privilege Escalation
- Id: T1068
- Reference URL: [[https://attack.mitre.org/techniques/T1068/](https://attack.mitre.org/techniques/T1068/)](https://attack.mitre.org/techniques/T1068/)
- Technique:
  - Name: Valid Accounts
- Id: T1078
- Reference URL: [[https://attack.mitre.org/techniques/T1078/](https://attack.mitre.org/techniques/T1078/)](https://attack.mitre.org/techniques/T1078/)
- Sub Technique:
  - Name: Domain Accounts
- Id: T1078.002
- Reference URL: [[https://attack.mitre.org/techniques/T1078/002/](https://attack.mitre.org/techniques/T1078/002/)](https://attack.mitre.org/techniques/T1078/002/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Account Manipulation
- Id: T1098
- Reference URL: [[https://attack.mitre.org/techniques/T1098/](https://attack.mitre.org/techniques/T1098/)](https://attack.mitre.org/techniques/T1098/)