﻿---
title: Suspicious DLL Loaded for Persistence or Privilege Escalation
description: Identifies the loading of a non Microsoft signed DLL that is missing on a default Windows install (phantom DLL) or one that can be loaded from a different...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_persistence_phantom_dll
products:
  - Elastic Security
---

# Suspicious DLL Loaded for Persistence or Privilege Escalation
Identifies the loading of a non Microsoft signed DLL that is missing on a default Windows install (phantom DLL) or one
that can be loaded from a different location by a native Windows process. This may be abused to persist or elevate
privileges via privileged file write vulnerabilities.
**Rule type**: eql
**Rule indices**:
- winlogbeat-*
- logs-endpoint.events.library-*
- logs-windows.sysmon_operational-*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://itm4n.github.io/windows-dll-hijacking-clarified/](https://itm4n.github.io/windows-dll-hijacking-clarified/)](https://itm4n.github.io/windows-dll-hijacking-clarified/)
- [http://remoteawesomethoughts.blogspot.com/2019/05/windows-10-task-schedulerservice.html](http://remoteawesomethoughts.blogspot.com/2019/05/windows-10-task-schedulerservice.html)
- [[https://googleprojectzero.blogspot.com/2018/04/windows-exploitation-tricks-exploiting.html](https://googleprojectzero.blogspot.com/2018/04/windows-exploitation-tricks-exploiting.html)](https://googleprojectzero.blogspot.com/2018/04/windows-exploitation-tricks-exploiting.html)
- [[https://shellz.club/2020/10/16/edgegdi-dll-for-persistence-and-lateral-movement.html](https://shellz.club/2020/10/16/edgegdi-dll-for-persistence-and-lateral-movement.html)](https://shellz.club/2020/10/16/edgegdi-dll-for-persistence-and-lateral-movement.html)
- [[https://windows-internals.com/faxing-your-way-to-system/](https://windows-internals.com/faxing-your-way-to-system/)](https://windows-internals.com/faxing-your-way-to-system/)
- [http://waleedassar.blogspot.com/2013/01/wow64logdll.html](http://waleedassar.blogspot.com/2013/01/wow64logdll.html)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Persistence
- Tactic: Privilege Escalation
- Tactic: Defense Evasion
- Resources: Investigation Guide
- Data Source: Elastic Defend
- Data Source: Sysmon

**Version**: 219
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

If enabling an EQL rule on a non-elastic-agent index (such as beats) for versions <8.2,
events will not define `event.ingested` and default fallback for EQL rules was not added until version 8.2.
Hence for this rule to work effectively, users will need to add a custom ingest pipeline to populate
`event.ingested` to @timestamp.
For more details on adding a custom ingest pipeline refer - [https://www.elastic.co/guide/en/fleet/current/data-streams-pipeline-tutorial.html](https://www.elastic.co/guide/en/fleet/current/data-streams-pipeline-tutorial.html)

## Investigation guide


## Triage and analysis


### Investigating Suspicious DLL Loaded for Persistence or Privilege Escalation

Attackers can execute malicious code by abusing missing modules that processes try to load, enabling them to escalate privileges or gain persistence. This rule identifies the loading of a non-Microsoft-signed DLL that is missing on a default Windows installation or one that can be loaded from a different location by a native Windows process.

#### Possible investigation steps

- Examine the DLL signature and identify the process that created it.
  - Investigate any abnormal behaviors by the process such as network connections, registry or file modifications, and any spawned child processes.
- Investigate other alerts associated with the user/host during the past 48 hours.
- Retrieve the DLL and determine if it is malicious:
  - Use a private sandboxed malware analysis system to perform analysis.
  - Observe and collect information about the following activities:
  - Attempts to contact external domains and addresses.
- File and registry access, modification, and creation activities.
- Service creation and launch activities.
- Scheduled task creation.
- Use the PowerShell Get-FileHash cmdlet to get the files' SHA-256 hash values.
  - Search for the existence and reputation of the hashes in resources like VirusTotal, Hybrid-Analysis, CISCO Talos, Any.run, etc.


### False positive analysis

- This activity is unlikely to happen legitimately. Any activity that triggered the alert and is not inherently malicious must be monitored by the security team.


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- Isolate the involved host to prevent further post-compromise behavior.
- If the triage identified malware, search the environment for additional compromised hosts.
  - Implement temporary network rules, procedures, and segmentation to contain the malware.
- Stop suspicious processes.
- Immediately block the identified indicators of compromise (IoCs).
- Inspect the affected systems for additional malware backdoors like reverse shells, reverse proxies, or droppers that attackers could use to reinfect the system.
- Remove and block malicious artifacts identified during triage.
- Run a full antimalware scan. This may reveal additional artifacts left in the system, persistence mechanisms, and malware components.
- Investigate credential exposure on systems compromised or used by the attacker to ensure all compromised accounts are identified. Reset passwords for these accounts and other potentially compromised credentials, such as email, business systems, and web services.
- Determine the initial vector abused by the attacker and take action to prevent reinfection through the same vector.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```eql
any where host.os.type == "windows" and 
(
  /*  Elastic Defend DLL load events */
  (event.category == "library" and 
    (
     ?dll.name : ("wlbsctrl.dll", "wbemcomn.dll", "WptsExtensions.dll", "Tsmsisrv.dll", "TSVIPSrv.dll", "Msfte.dll", "wow64log.dll", "WindowsCoreDeviceInfo.dll", "Ualapi.dll", "wlanhlp.dll", "phoneinfo.dll", "EdgeGdi.dll", "cdpsgshims.dll", "windowsperformancerecordercontrol.dll", "diagtrack_win.dll", "TPPCOIPW32.dll", "tpgenlic.dll", "thinmon.dll", "fxsst.dll", "msTracer.dll") or 

     (?dll.path : "?:\\Windows\\*\\oci.dll" and process.executable : "?:\\Windows\\*.exe")
     )
    and (?dll.code_signature.trusted == false or ?dll.code_signature.exists == false or (?dll.code_signature.trusted == true and not ?dll.code_signature.subject_name : ("Microsoft Windows", "Microsoft Corporation", "Microsoft Windows Publisher"))
      ))
   or

  /*  Sysmon DLL load events */
  ((event.category == "process" and event.action like "Image loaded*") and file.code_signature.status != "Valid" and 
  file.name : ("wlbsctrl.dll", "wbemcomn.dll", "WptsExtensions.dll", "Tsmsisrv.dll", "TSVIPSrv.dll", "Msfte.dll", "wow64log.dll", "WindowsCoreDeviceInfo.dll", "Ualapi.dll", "wlanhlp.dll", "phoneinfo.dll", "EdgeGdi.dll", "cdpsgshims.dll", "windowsperformancerecordercontrol.dll", "diagtrack_win.dll", "TPPCOIPW32.dll", "tpgenlic.dll", "thinmon.dll", "fxsst.dll", "msTracer.dll") and 
   not file.hash.sha256 in 
            ("6e837794fc282446906c36d681958f2f6212043fc117c716936920be166a700f", 
             "b14e4954e8cca060ffeb57f2458b6a3a39c7d2f27e94391cbcea5387652f21a4", 
             "c258d90acd006fa109dc6b748008edbb196d6168bc75ace0de0de54a4db46662", 
             "254e5053ac04b7623e86234077876388e0b10c3ac5c3f4e4e86292b62571bfb0")) 

) and not
  (
    ?dll.path : (
      "?:\\Windows\\System32\\wbemcomn.dll",
      "?:\\Windows\\SysWOW64\\wbemcomn.dll",
      "?:\\Windows\\System32\\windowsperformancerecordercontrol.dll",
      "?:\\Windows\\System32\\wlanhlp.dll", 
      "\\Device\\HarddiskVolume?\\Windows\\SysWOW64\\wbemcomn.dll", 
      "\\Device\\HarddiskVolume?\\Windows\\System32\\wbemcomn.dll", 
      "\\Device\\HarddiskVolume?\\Windows\\SysWOW64\\wlanhlp.dll", 
      "\\Device\\HarddiskVolume?\\Windows\\System32\\wlanhlp.dll", 
      "\\Device\\HarddiskVolume?\\Windows\\SysWOW64\\windowsperformancerecordercontrol.dll", 
      "\\Device\\HarddiskVolume?\\Windows\\System32\\windowsperformancerecordercontrol.dll", 
      "C:\\ProgramData\\docker\\windowsfilter\\*\\Files\\Windows\\System32\\windowsperformancerecordercontrol.dll", 
      "\\Device\\vmsmb\\VSMB-{*}\\os\\windows\\system32\\*.dll", 
      "C:\\Windows\\WinSxS\\amd64_microsoft-windows-wmi-core-wbemcomn-dll_*\\wbemcomn.dll", 
      "C:\\Windows\\WinSxS\\wow64_microsoft-windows-wmi-core-wbemcomn-dll_*\\wbemcomn.dll", 
      "C:\\Windows\\WinSxS\\amd64_microsoft-windows-coresystem-wpr_*\\windowsperformancerecordercontrol.dll"
    ) or
    
    file.path : (
      "?:\\Windows\\System32\\wbemcomn.dll",
      "?:\\Windows\\SysWOW64\\wbemcomn.dll",
      "?:\\Windows\\System32\\windowsperformancerecordercontrol.dll",
      "?:\\Windows\\System32\\wlanhlp.dll", 
      "C:\\ProgramData\\docker\\windowsfilter\\*\\Files\\Windows\\System32\\windowsperformancerecordercontrol.dll", 
      "C:\\ProgramData\\docker\\windowsfilter\\*\\Files\\Windows\\System32\\wbemcomn.dll", 
      "\\Device\\vmsmb\\VSMB-{*}\\os\\windows\\system32\\*.dll", 
      "C:\\Windows\\WinSxS\\amd64_microsoft-windows-wmi-core-wbemcomn-dll_*\\wbemcomn.dll", 
      "C:\\Windows\\WinSxS\\wow64_microsoft-windows-wmi-core-wbemcomn-dll_*\\wbemcomn.dll"
    ) or 

 ?dll.code_signature.status like "errorCode_endpoint*"
  )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Hijack Execution Flow
- Id: T1574
- Reference URL: [[https://attack.mitre.org/techniques/T1574/](https://attack.mitre.org/techniques/T1574/)](https://attack.mitre.org/techniques/T1574/)
- Sub Technique:
  - Name: DLL
- Id: T1574.001
- Reference URL: [[https://attack.mitre.org/techniques/T1574/001/](https://attack.mitre.org/techniques/T1574/001/)](https://attack.mitre.org/techniques/T1574/001/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Masquerading
- Id: T1036
- Reference URL: [[https://attack.mitre.org/techniques/T1036/](https://attack.mitre.org/techniques/T1036/)](https://attack.mitre.org/techniques/T1036/)
- Sub Technique:
  - Name: Invalid Code Signature
- Id: T1036.001
- Reference URL: [[https://attack.mitre.org/techniques/T1036/001/](https://attack.mitre.org/techniques/T1036/001/)](https://attack.mitre.org/techniques/T1036/001/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Hijack Execution Flow
- Id: T1574
- Reference URL: [[https://attack.mitre.org/techniques/T1574/](https://attack.mitre.org/techniques/T1574/)](https://attack.mitre.org/techniques/T1574/)
- Sub Technique:
  - Name: DLL
- Id: T1574.001
- Reference URL: [[https://attack.mitre.org/techniques/T1574/001/](https://attack.mitre.org/techniques/T1574/001/)](https://attack.mitre.org/techniques/T1574/001/)