﻿---
title: Potential LSA Authentication Package Abuse
description: Adversaries can use the autostart mechanism provided by the Local Security Authority (LSA) authentication packages for privilege escalation or persistence...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_lsa_auth_package
products:
  - Elastic Security
---

# Potential LSA Authentication Package Abuse
Adversaries can use the autostart mechanism provided by the Local Security Authority (LSA) authentication packages for
privilege escalation or persistence by placing a reference to a binary in the Windows registry. The binary will then be
executed by SYSTEM when the authentication packages are loaded.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.registry-*
- endgame-*
- logs-m365_defender.event-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Privilege Escalation
- Data Source: Elastic Endgame
- Data Source: Elastic Defend
- Data Source: Microsoft Defender for Endpoint
- Resources: Investigation Guide

**Version**: 109
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Potential LSA Authentication Package Abuse

The Local Security Authority (LSA) in Windows manages authentication and security policies. Adversaries exploit LSA by modifying registry paths to include malicious binaries, which are executed with SYSTEM privileges during authentication package loading. The detection rule identifies unauthorized registry changes by non-SYSTEM users, signaling potential privilege escalation or persistence attempts.

### Possible investigation steps

- Review the registry change event details to identify the specific binary path added to the LSA Authentication Packages registry key.
- Investigate the user account associated with the registry change event to determine if it is a legitimate user or potentially compromised.
- Check the timestamp of the registry modification to correlate with any other suspicious activities or events on the system around the same time.
- Analyze the binary referenced in the registry change for any known malicious signatures or behaviors using antivirus or threat intelligence tools.
- Examine system logs and security events for any signs of privilege escalation or persistence techniques used by the adversary.
- Assess the system for any additional unauthorized changes or indicators of compromise that may suggest further malicious activity.


### False positive analysis

- Legitimate software installations or updates may modify the LSA authentication package registry path. Users should verify if recent installations or updates coincide with the detected changes and consider excluding these specific software processes if they are deemed safe.
- System administrators or IT management tools might perform authorized changes to the registry for maintenance or configuration purposes. Users can create exceptions for known administrative tools or processes that are regularly used for legitimate system management tasks.
- Security software or endpoint protection solutions may alter the registry as part of their normal operation. Users should identify and whitelist these security applications to prevent unnecessary alerts.
- Custom scripts or automation tools used within the organization might inadvertently trigger this rule. Users should review and document these scripts, ensuring they are secure, and exclude them if they are confirmed to be non-threatening.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further unauthorized access or lateral movement.
- Terminate any suspicious processes associated with the unauthorized registry change to halt potential malicious activity.
- Restore the modified registry path to its original state by removing any unauthorized entries in the LSA Authentication Packages registry key.
- Conduct a thorough scan of the affected system using updated antivirus or endpoint detection and response (EDR) tools to identify and remove any malicious binaries or remnants.
- Review and reset credentials for any accounts that may have been compromised, focusing on those with elevated privileges.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if additional systems are affected.
- Implement enhanced monitoring and logging for registry changes, particularly those involving LSA authentication packages, to detect and respond to similar threats in the future.


## Rule Query

```eql
registry where host.os.type == "windows" and event.type == "change" and
  registry.path : (
      "HKLM\\SYSTEM\\*ControlSet*\\Control\\Lsa\\Authentication Packages",
      "\\REGISTRY\\MACHINE\\SYSTEM\\*ControlSet*\\Control\\Lsa\\Authentication Packages"
  ) and
  /* exclude SYSTEM SID - look for changes by non-SYSTEM user */
  not user.id : "S-1-5-18"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Boot or Logon Autostart Execution
- Id: T1547
- Reference URL: [[https://attack.mitre.org/techniques/T1547/](https://attack.mitre.org/techniques/T1547/)](https://attack.mitre.org/techniques/T1547/)
- Sub Technique:
  - Name: Authentication Package
- Id: T1547.002
- Reference URL: [[https://attack.mitre.org/techniques/T1547/002/](https://attack.mitre.org/techniques/T1547/002/)](https://attack.mitre.org/techniques/T1547/002/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Boot or Logon Autostart Execution
- Id: T1547
- Reference URL: [[https://attack.mitre.org/techniques/T1547/](https://attack.mitre.org/techniques/T1547/)](https://attack.mitre.org/techniques/T1547/)
- Sub Technique:
  - Name: Authentication Package
- Id: T1547.002
- Reference URL: [[https://attack.mitre.org/techniques/T1547/002/](https://attack.mitre.org/techniques/T1547/002/)](https://attack.mitre.org/techniques/T1547/002/)