﻿---
title: Potential privilege escalation via CVE-2022-38028
description: Identifies a privilege escalation attempt via exploiting CVE-2022-38028 to hijack the print spooler service execution. Rule type: eql Rule indices: logs-endpoint.events.file-*,...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_exploit_cve_202238028
products:
  - Elastic Security
---

# Potential privilege escalation via CVE-2022-38028
Identifies a privilege escalation attempt via exploiting CVE-2022-38028 to hijack the print spooler service execution.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.file-*
- logs-windows.sysmon_operational-*
- endgame-*
- winlogbeat-*
- logs-m365_defender.event-*
- logs-sentinel_one_cloud_funnel.*
- logs-crowdstrike.fdr*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.microsoft.com/en-us/security/blog/2024/04/22/analyzing-forest-blizzards-custom-post-compromise-tool-for-exploiting-cve-2022-38028-to-obtain-credentials/](https://www.microsoft.com/en-us/security/blog/2024/04/22/analyzing-forest-blizzards-custom-post-compromise-tool-for-exploiting-cve-2022-38028-to-obtain-credentials/)](https://www.microsoft.com/en-us/security/blog/2024/04/22/analyzing-forest-blizzards-custom-post-compromise-tool-for-exploiting-cve-2022-38028-to-obtain-credentials/)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Privilege Escalation
- Tactic: Defense Evasion
- Data Source: Elastic Endgame
- Data Source: Elastic Defend
- Data Source: Sysmon
- Data Source: Microsoft Defender for Endpoint
- Data Source: SentinelOne
- Data Source: Crowdstrike
- Resources: Investigation Guide

**Version**: 208
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Potential privilege escalation via CVE-2022-38028

CVE-2022-38028 targets the Windows Print Spooler service, a core component managing print jobs. Adversaries exploit this by manipulating specific JavaScript files within system directories to gain elevated privileges. The detection rule identifies unauthorized file presence in critical paths, signaling potential exploitation attempts, leveraging multiple data sources for comprehensive threat detection.

### Possible investigation steps

- Review the alert details to confirm the presence of the file "MPDW-constraints.js" in the specified critical paths: "?:\*\Windows\system32\DriVerStoRe\FiLeRePoSiToRy\*\MPDW-constraints.js" or "?:\*\Windows\WinSxS\amd64_microsoft-windows-printing-printtopdf_*\MPDW-constraints.js".
- Check the file creation and modification timestamps to determine when the file was placed or altered in the system directories.
- Investigate the source of the file by examining recent user activity and process execution logs around the time the file appeared, focusing on any suspicious or unauthorized actions.
- Correlate the event with other data sources such as Sysmon, Microsoft Defender for Endpoint, or SentinelOne to identify any related suspicious activities or processes that might indicate exploitation attempts.
- Assess the risk and impact by determining if the affected system has any sensitive roles or access that could be leveraged by an attacker through privilege escalation.
- If malicious activity is confirmed, initiate containment measures such as isolating the affected system and conducting a full malware scan to prevent further exploitation.


### False positive analysis

- Legitimate software updates or installations may place JavaScript files in the monitored directories. Verify the source and integrity of the software to ensure it is from a trusted vendor.
- System administrators or automated scripts might deploy or modify JavaScript files in these paths for legitimate configuration purposes. Review change management logs to confirm authorized activities.
- Security tools or system maintenance processes could temporarily create or modify files in these directories. Cross-reference with scheduled tasks or security tool logs to validate these actions.
- Exclude known benign applications or processes that frequently interact with the specified file paths by creating exceptions in the detection rule to reduce noise.
- Regularly update the detection rule to incorporate new intelligence on false positives, ensuring it remains effective and relevant.


### Response and remediation

- Isolate the affected system from the network immediately to prevent further exploitation or lateral movement by the adversary.
- Terminate any suspicious processes related to the Windows Print Spooler service to halt ongoing exploitation attempts.
- Remove unauthorized JavaScript files, specifically "MPDW-constraints.js", from the identified critical paths to eliminate the immediate threat.
- Apply the latest security patches and updates from Microsoft to address CVE-2022-38028 and ensure the system is protected against known vulnerabilities.
- Conduct a thorough review of user accounts and privileges on the affected system to identify and revoke any unauthorized privilege escalations.
- Monitor the network and system logs for any signs of further exploitation attempts or related suspicious activities, using enhanced detection rules.
- Report the incident to the appropriate internal security team or external authorities if required, providing detailed information about the exploitation attempt and actions taken.


## Rule Query

```eql
file where host.os.type == "windows" and event.type != "deletion" and
    file.name : "MPDW-constraints.js" and
    file.path : (
        "?:\\*\\Windows\\system32\\DriverStore\\FileRepository\\*\\MPDW-constraints.js",
        "?:\\*\\Windows\\WinSxS\\amd64_microsoft-windows-printing-printtopdf_*\\MPDW-constraints.js", 
        "\\Device\\HarddiskVolume*\\*\\Windows\\system32\\DriverStore\\FileRepository\\*\\MPDW-constraints.js",
        "\\Device\\HarddiskVolume*\\*\\Windows\\WinSxS\\amd64_microsoft-windows-printing-printtopdf_*\\MPDW-constraints.js"
    ) and
    not process.executable : (
          "?:\\$WINDOWS.~BT\\Sources\\SetupHost.exe",
          "?:\\Windows\\System32\\taskhostw.exe"
    ) and
    not file.path : (
        "?:\\$WINDOWS.~BT\\NewOS\\Windows\\WinSxS\\*\\MPDW-constraints.js",
        "\\Device\\HarddiskVolume*\\$WINDOWS.~BT\\NewOS\\Windows\\WinSxS\\*\\MPDW-constraints.js"
    )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Exploitation for Privilege Escalation
- Id: T1068
- Reference URL: [[https://attack.mitre.org/techniques/T1068/](https://attack.mitre.org/techniques/T1068/)](https://attack.mitre.org/techniques/T1068/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Masquerading
- Id: T1036
- Reference URL: [[https://attack.mitre.org/techniques/T1036/](https://attack.mitre.org/techniques/T1036/)](https://attack.mitre.org/techniques/T1036/)