﻿---
title: Modification of the msPKIAccountCredentials
description: Identify the modification of the msPKIAccountCredentials attribute in an Active Directory User Object. Attackers can abuse the credentials roaming feature...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_credroaming_ldap
products:
  - Elastic Security
---

# Modification of the msPKIAccountCredentials
Identify the modification of the msPKIAccountCredentials attribute in an Active Directory User Object. Attackers can
abuse the credentials roaming feature to overwrite an arbitrary file for privilege escalation. ms-PKI-AccountCredentials
contains binary large objects (BLOBs) of encrypted credential objects from the credential manager store, private keys,
certificates, and certificate requests.
**Rule type**: query
**Rule indices**:
- winlogbeat-*
- logs-system.security*
- logs-windows.forwarded*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.mandiant.com/resources/blog/apt29-windows-credential-roaming](https://www.mandiant.com/resources/blog/apt29-windows-credential-roaming)](https://www.mandiant.com/resources/blog/apt29-windows-credential-roaming)
- [[https://social.technet.microsoft.com/wiki/contents/articles/11483.windows-credential-roaming.aspx](https://social.technet.microsoft.com/wiki/contents/articles/11483.windows-credential-roaming.aspx)](https://social.technet.microsoft.com/wiki/contents/articles/11483.windows-credential-roaming.aspx)
- [[https://learn.microsoft.com/en-us/windows/security/threat-protection/auditing/event-5136](https://learn.microsoft.com/en-us/windows/security/threat-protection/auditing/event-5136)](https://learn.microsoft.com/en-us/windows/security/threat-protection/auditing/event-5136)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Data Source: Active Directory
- Tactic: Privilege Escalation
- Use Case: Active Directory Monitoring
- Data Source: Windows Security Event Logs
- Resources: Investigation Guide

**Version**: 118
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

The 'Audit Directory Service Changes' logging policy must be configured for (Success, Failure).
Steps to implement the logging policy with Advanced Audit Configuration:
```
Computer Configuration >
Policies >
Windows Settings >
Security Settings >
Advanced Audit Policies Configuration >
Audit Policies >
DS Access >
Audit Directory Service Changes (Success,Failure)
```


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Modification of the msPKIAccountCredentials

The msPKIAccountCredentials attribute in Active Directory stores encrypted credential data, including private keys and certificates. Adversaries may exploit this by altering the attribute to escalate privileges, potentially overwriting files. The detection rule identifies such modifications by monitoring specific directory service events, focusing on changes to this attribute, excluding actions by the system account, thus highlighting unauthorized access attempts.

### Possible investigation steps

- Review the event logs for the specific event code 5136 to gather details about the modification event, including the timestamp and the user account involved.
- Examine the winlog.event_data.SubjectUserSid field to identify the user who attempted the modification, ensuring it is not the system account (S-1-5-18).
- Investigate the history and behavior of the identified user account to determine if there are any previous suspicious activities or anomalies.
- Check for any recent changes or anomalies in the affected Active Directory User Object, focusing on the msPKIAccountCredentials attribute.
- Assess the potential impact of the modification by identifying any files or systems that may have been affected by the altered credentials.
- Correlate this event with other security alerts or logs to identify any patterns or coordinated activities that might indicate a broader attack.


### False positive analysis

- Routine administrative tasks by IT personnel may trigger the rule. To manage this, create exceptions for specific user accounts or groups known to perform these tasks regularly.
- Scheduled maintenance scripts or automated processes that modify Active Directory attributes could be mistaken for unauthorized changes. Identify these processes and exclude their associated user accounts or service accounts from the rule.
- Software updates or installations that require changes to user credentials might cause false positives. Document these events and adjust the rule to ignore modifications during known update windows.
- Legitimate changes made by third-party applications integrated with Active Directory can be flagged. Review and whitelist these applications by excluding their associated user accounts or service accounts.
- Temporary changes during incident response or security audits may appear suspicious. Coordinate with security teams to ensure these activities are recognized and excluded from triggering alerts.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further unauthorized access or data exfiltration.
- Revoke any potentially compromised certificates and private keys associated with the affected msPKIAccountCredentials attribute to prevent misuse.
- Conduct a thorough review of recent changes in Active Directory, focusing on the msPKIAccountCredentials attribute, to identify any unauthorized modifications or access patterns.
- Reset passwords and regenerate keys for any accounts or services that may have been affected to ensure that compromised credentials are no longer valid.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine the full scope of the breach.
- Implement additional monitoring on the affected systems and accounts to detect any further suspicious activity or attempts to exploit similar vulnerabilities.
- Review and update access controls and permissions in Active Directory to ensure that only authorized personnel have the ability to modify sensitive attributes like msPKIAccountCredentials.


## Rule Query

```kuery
event.code:"5136" and host.os.type:"windows" and winlog.event_data.AttributeLDAPDisplayName:"msPKIAccountCredentials" and
  winlog.event_data.OperationType:"%%14674" and
  not winlog.event_data.SubjectUserSid : "S-1-5-18"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Exploitation for Privilege Escalation
- Id: T1068
- Reference URL: [[https://attack.mitre.org/techniques/T1068/](https://attack.mitre.org/techniques/T1068/)](https://attack.mitre.org/techniques/T1068/)