﻿---
title: Process Creation via Secondary Logon
description: Identifies process creation with alternate credentials. Adversaries may create a new process with a different token to escalate privileges and bypass...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_create_process_as_different_user
products:
  - Elastic Security
---

# Process Creation via Secondary Logon
Identifies process creation with alternate credentials. Adversaries may create a new process with a different token to
escalate privileges and bypass access controls.
**Rule type**: eql
**Rule indices**:
- logs-system.security*
- logs-windows.forwarded*
- winlogbeat-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://attack.mitre.org/techniques/T1134/002/](https://attack.mitre.org/techniques/T1134/002/)](https://attack.mitre.org/techniques/T1134/002/)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Privilege Escalation
- Data Source: Windows Security Event Logs
- Resources: Investigation Guide

**Version**: 115
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

Audit events 4624 and 4688 are needed to trigger this rule.

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Process Creation via Secondary Logon

The Secondary Logon service in Windows allows users to run processes with different credentials, facilitating legitimate administrative tasks. However, adversaries can exploit this to escalate privileges by creating processes with alternate tokens, bypassing access controls. The detection rule identifies such abuse by monitoring successful logins via the Secondary Logon service and subsequent process creation, linking them through unique logon identifiers.

### Possible investigation steps

- Review the event logs for the specific TargetLogonId to identify the user account associated with the process creation and verify if the account is authorized to use alternate credentials.
- Examine the source IP address "::1" to confirm if the process creation originated from the local machine, which might indicate a local privilege escalation attempt.
- Investigate the process name "svchost.exe" to determine if it is being used legitimately or if it has been exploited for malicious purposes, such as running unauthorized services.
- Check the sequence of events within the 1-minute maxspan to identify any unusual or suspicious activities that occurred immediately before or after the process creation.
- Correlate the detected activity with other security alerts or logs to identify any patterns or additional indicators of compromise that might suggest a broader attack campaign.


### False positive analysis

- Legitimate administrative tasks using the Secondary Logon service can trigger alerts. To manage this, identify and whitelist specific administrative accounts or tasks that frequently use this service for legitimate purposes.
- Scheduled tasks or automated scripts that use alternate credentials for routine operations may cause false positives. Review and exclude these tasks by creating exceptions for known scripts or scheduled jobs.
- Internal IT support activities often involve using alternate credentials for troubleshooting or maintenance. Document and exclude these activities by maintaining a list of support personnel and their typical actions.
- Software updates or installations that require elevated privileges might be flagged. Monitor and exclude these processes by identifying and documenting the update mechanisms used within the organization.
- Development or testing environments where alternate credentials are used for testing purposes can generate alerts. Exclude these environments by setting up specific rules that recognize and ignore these non-production activities.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further unauthorized access or lateral movement by the adversary.
- Terminate any suspicious processes identified as being created via the Secondary Logon service, especially those linked to the unique logon identifiers from the alert.
- Review and revoke any alternate credentials or tokens used in the suspicious process creation to prevent further misuse.
- Conduct a thorough examination of the affected system for additional signs of compromise, such as unauthorized user accounts or changes to system configurations.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine the full scope of the breach.
- Implement stricter access controls and monitoring on the Secondary Logon service to detect and prevent similar privilege escalation attempts in the future.
- Update and reinforce endpoint detection and response (EDR) solutions to enhance monitoring of process creation events and logon activities, ensuring they are aligned with the latest threat intelligence.


## Rule Query

```eql
sequence by winlog.computer_name with maxspan=1m

[authentication where host.os.type == "windows" and event.action:"logged-in" and
 event.outcome == "success" and user.id : ("S-1-5-21-*", "S-1-12-1-*") and

 /* seclogon service */
 process.name == "svchost.exe" and
 winlog.event_data.LogonProcessName : "seclogo*" and source.ip == "::1" ] by winlog.event_data.TargetLogonId

[process where host.os.type == "windows" and event.type == "start"] by winlog.event_data.TargetLogonId
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Access Token Manipulation
- Id: T1134
- Reference URL: [[https://attack.mitre.org/techniques/T1134/](https://attack.mitre.org/techniques/T1134/)](https://attack.mitre.org/techniques/T1134/)
- Sub Technique:
  - Name: Create Process with Token
- Id: T1134.002
- Reference URL: [[https://attack.mitre.org/techniques/T1134/002/](https://attack.mitre.org/techniques/T1134/002/)](https://attack.mitre.org/techniques/T1134/002/)
- Sub Technique:
  - Name: Make and Impersonate Token
- Id: T1134.003
- Reference URL: [[https://attack.mitre.org/techniques/T1134/003/](https://attack.mitre.org/techniques/T1134/003/)](https://attack.mitre.org/techniques/T1134/003/)