﻿---
title: Delegated Managed Service Account Modification by an Unusual User
description: Detects modifications in the msDS-ManagedAccountPrecededByLink attribute of a delegated managed service account by an unusual subject account. Attackers...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_badsuccessor_dmsa_abuse
products:
  - Elastic Security
---

# Delegated Managed Service Account Modification by an Unusual User
Detects modifications in the msDS-ManagedAccountPrecededByLink attribute of a delegated managed service account by an unusual
subject account. Attackers can abuse this attribute to take over the permission of a target account and inherit it's permissions
allowing them to further elevate privileges.
**Rule type**: new_terms
**Rule indices**:
- winlogbeat-*
- logs-system.security*
- logs-windows.forwarded*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.akamai.com/blog/security-research/abusing-dmsa-for-privilege-escalation-in-active-directory](https://www.akamai.com/blog/security-research/abusing-dmsa-for-privilege-escalation-in-active-directory)](https://www.akamai.com/blog/security-research/abusing-dmsa-for-privilege-escalation-in-active-directory)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Privilege Escalation
- Use Case: Active Directory Monitoring
- Data Source: Active Directory
- Data Source: Windows Security Event Logs
- Resources: Investigation Guide

**Version**: 2
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Delegated Managed Service Account Modification by an Unusual User


### Possible investigation steps

- Examine the winlog.event_data.SubjectUserName field and verify if he is allowed and used to perform this kind of dMSA changes.
- Examine the winlog.event_data.AttributeValue field to verify the targeted account and if it's supposed to use dMSA.
- Examine if there are any recent dMSA account creation by the same winlog.event_data.SubjectUserName.
- Investigate the history of the identified user account to determine if there are any other suspicious activities or patterns of behavior.
- Collaborate with the IT or security team to determine if the changes were authorized or if further action is needed to secure the environment.


### False positive analysis

- Migration of legacy service accounts using delegated managed service account.


### Response and remediation

- Immediately disable the winlog.event_data.SubjectUserName account and revert all changes performed by that account.
- Identify and isolate the source machines from where the SubjectUserName is authenticating.
- Reset passwords for all accounts that were potentially affected or had their permissions altered, focusing on privileged accounts to prevent adversaries from regaining access.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine the scope of the breach, including identifying any other compromised systems or accounts.
- Review and update access control policies and security configurations to prevent similar attacks, ensuring that only authorized personnel have the ability to modify critical Active Directory objects or create OU child objects.


## Rule Query

```kuery
event.code:5136 and host.os.type:"windows" and winlog.event_data.AttributeLDAPDisplayName:"msDS-ManagedAccountPrecededByLink"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Valid Accounts
- Id: T1078
- Reference URL: [[https://attack.mitre.org/techniques/T1078/](https://attack.mitre.org/techniques/T1078/)](https://attack.mitre.org/techniques/T1078/)
- Sub Technique:
  - Name: Domain Accounts
- Id: T1078.002
- Reference URL: [[https://attack.mitre.org/techniques/T1078/002/](https://attack.mitre.org/techniques/T1078/002/)](https://attack.mitre.org/techniques/T1078/002/)
- Technique:
  - Name: Account Manipulation
- Id: T1098
- Reference URL: [[https://attack.mitre.org/techniques/T1098/](https://attack.mitre.org/techniques/T1098/)](https://attack.mitre.org/techniques/T1098/)