﻿---
title: Potential Web Shell ASPX File Creation
description: Identifies the creation of ASPX files in specific directories that are commonly targeted by attackers to deploy web shells. Rule type: eql Rule indices:...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_web_shell_aspx_write
products:
  - Elastic Security
---

# Potential Web Shell ASPX File Creation
Identifies the creation of ASPX files in specific directories that are commonly targeted by attackers to deploy web shells.
**Rule type**: eql
**Rule indices**:
- winlogbeat-*
- logs-endpoint.events.file-*
- logs-windows.sysmon_operational-*
- endgame-*
- logs-sentinel_one_cloud_funnel.*
- logs-m365_defender.event-*
- logs-crowdstrike.fdr*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://blog.viettelcybersecurity.com/toolshell-a-critical-sharepoint-vulnerability-chain-under-active-exploitation/](https://blog.viettelcybersecurity.com/toolshell-a-critical-sharepoint-vulnerability-chain-under-active-exploitation/)](https://blog.viettelcybersecurity.com/toolshell-a-critical-sharepoint-vulnerability-chain-under-active-exploitation/)
- [[https://www.sentinelone.com/blog/sharepoint-toolshell-zero-day-exploited-in-the-wild-targets-enterprise-servers/](https://www.sentinelone.com/blog/sharepoint-toolshell-zero-day-exploited-in-the-wild-targets-enterprise-servers/)](https://www.sentinelone.com/blog/sharepoint-toolshell-zero-day-exploited-in-the-wild-targets-enterprise-servers/)
- [[https://www.rapid7.com/blog/post/2024/10/30/investigating-a-sharepoint-compromise-ir-tales-from-the-field/](https://www.rapid7.com/blog/post/2024/10/30/investigating-a-sharepoint-compromise-ir-tales-from-the-field/)](https://www.rapid7.com/blog/post/2024/10/30/investigating-a-sharepoint-compromise-ir-tales-from-the-field/)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Persistence
- Data Source: Elastic Endgame
- Data Source: Elastic Defend
- Data Source: Sysmon
- Data Source: SentinelOne
- Data Source: Microsoft Defender for Endpoint
- Data Source: Crowdstrike
- Resources: Investigation Guide

**Version**: 2
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Potential Web Shell ASPX File Creation

Web shells are malicious scripts uploaded to web servers, often exploiting vulnerabilities in web applications. ASPX files, used in Windows environments, can be manipulated by attackers to maintain persistence and execute arbitrary commands. Adversaries target specific directories for deploying these files. The detection rule identifies suspicious ASPX file creation in these directories, excluding legitimate processes, to flag potential web shell activity.

### Possible investigation steps

- Review the file path where the ASPX file was created to confirm it matches the targeted directory pattern: "?:\Program Files\Common Files\Microsoft Shared\Web Server Extensions*". This can help determine if the file is in a location commonly exploited for web shells.
- Examine the process that created the ASPX file, ensuring it is not the legitimate "?:\Windows\System32\msiexec.exe". Investigate the actual process responsible for the file creation to assess its legitimacy and potential malicious intent.
- Check the timestamp of the file creation event to correlate it with other suspicious activities or alerts on the host, which might provide additional context or evidence of compromise.
- Investigate the contents of the ASPX file to identify any malicious code or scripts that could indicate a web shell. Look for patterns or code snippets commonly associated with web shell functionality.
- Analyze network activity from the host around the time of the ASPX file creation to identify any unusual outbound connections or data transfers that might suggest communication with a command and control server.
- Review historical alerts and logs for the host to identify any previous suspicious activities or patterns that could indicate ongoing compromise or persistence mechanisms.


### False positive analysis

- Routine updates or installations of legitimate web server components may trigger alerts. Users can create exceptions for known update processes or installation paths to reduce false positives.
- Development or testing environments often generate ASPX files as part of normal operations. Exclude directories or processes associated with these environments to prevent unnecessary alerts.
- Automated scripts or tools used for web server maintenance might create ASPX files. Identify and whitelist these scripts to avoid false detections.
- Legitimate third-party applications that integrate with web server extensions may create ASPX files. Monitor and whitelist these applications to ensure they do not trigger false positives.
- Scheduled tasks or system processes that interact with web server directories can be mistaken for malicious activity. Review and exclude these tasks if they are verified as non-threatening.


### Response and remediation

- Isolate the affected server from the network to prevent further malicious activity and lateral movement.
- Terminate any suspicious processes associated with the creation of the ASPX file, especially those not originating from legitimate executables like msiexec.exe.
- Remove the identified ASPX file from the targeted directory to eliminate the potential web shell.
- Conduct a thorough scan of the server using updated antivirus and endpoint detection tools to identify and remove any additional malicious files or processes.
- Review server logs and network traffic for signs of unauthorized access or data exfiltration, and document any findings for further analysis.
- Restore the server from a known good backup if necessary, ensuring that the backup is free from any malicious artifacts.
- Escalate the incident to the security operations team for further investigation and to assess the need for additional security measures, such as patching vulnerabilities or enhancing monitoring capabilities.


## Rule Query

```eql
file where host.os.type == "windows" and event.type != "deletion" and
  file.extension : "aspx" and
  file.path : "?:\\Program Files\\Common Files\\Microsoft Shared\\Web Server Extensions\\*" and
  not process.executable: (
        "?:\\Windows\\System32\\msiexec.exe",
        "?:\\Program Files\\Common Files\\Microsoft Shared\\Web Server Extensions\\16\\BIN\\psconfigui.exe"
  )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Server Software Component
- Id: T1505
- Reference URL: [[https://attack.mitre.org/techniques/T1505/](https://attack.mitre.org/techniques/T1505/)](https://attack.mitre.org/techniques/T1505/)
- Sub Technique:
  - Name: Web Shell
- Id: T1505.003
- Reference URL: [[https://attack.mitre.org/techniques/T1505/003/](https://attack.mitre.org/techniques/T1505/003/)](https://attack.mitre.org/techniques/T1505/003/)