﻿---
title: Execution via MSSQL xp_cmdshell Stored Procedure
description: Identifies execution via MSSQL xp_cmdshell stored procedure. Malicious users may attempt to elevate their privileges by using xp_cmdshell, which is disabled...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_via_xp_cmdshell_mssql_stored_procedure
products:
  - Elastic Security
---

# Execution via MSSQL xp_cmdshell Stored Procedure
Identifies execution via MSSQL xp_cmdshell stored procedure. Malicious users may attempt to elevate their privileges by
using xp_cmdshell, which is disabled by default, thus, it's important to review the context of it's use.
**Rule type**: new_terms
**Rule indices**:
- endgame-*
- logs-crowdstrike.fdr*
- logs-endpoint.events.process-*
- logs-m365_defender.event-*
- logs-sentinel_one_cloud_funnel.*
- logs-system.security*
- logs-windows.forwarded*
- logs-windows.sysmon_operational-*
- winlogbeat-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://thedfirreport.com/2022/07/11/select-xmrig-from-sqlserver/](https://thedfirreport.com/2022/07/11/select-xmrig-from-sqlserver/)](https://thedfirreport.com/2022/07/11/select-xmrig-from-sqlserver/)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Persistence
- Resources: Investigation Guide
- Data Source: Elastic Endgame
- Data Source: Elastic Defend
- Data Source: Windows Security Event Logs
- Data Source: Microsoft Defender for Endpoint
- Data Source: Sysmon
- Data Source: SentinelOne
- Data Source: Crowdstrike

**Version**: 317
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Execution via MSSQL xp_cmdshell Stored Procedure

Microsoft SQL Server (MSSQL) has procedures meant to extend its functionality, the Extended Stored Procedures. These procedures are external functions written in C/C++; some provide interfaces for external programs. This is the case for xp_cmdshell, which spawns a Windows command shell and passes in a string for execution. Attackers can use this to execute commands on the system running the SQL server, commonly to escalate their privileges and establish persistence.
The xp_cmdshell procedure is disabled by default, but when used, it has the same security context as the MSSQL Server service account, which is often privileged.

#### Possible investigation steps

- Investigate the process execution chain (parent process tree) for unknown processes. Examine their executable files for prevalence, whether they are located in expected locations, and if they are signed with valid digital signatures.
- Investigate other alerts associated with the user/host during the past 48 hours.
- Investigate any abnormal account behavior, such as command executions, file creations or modifications, and network connections.
- Investigate any abnormal behavior by the subject process such as network connections, registry or file modifications, and any spawned child processes.
- Examine the command line to determine if the command executed is potentially harmful or malicious.
- Inspect the host for suspicious or abnormal behavior in the alert timeframe.


### False positive analysis

- This mechanism can be used legitimately, but it brings inherent risk. The security team must monitor any activity of it. If recurrent tasks are being executed using this mechanism, consider adding exceptions — preferably with a full command line.


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- Isolate the involved hosts to prevent further post-compromise behavior.
- Remove and block malicious artifacts identified during triage.
- Investigate credential exposure on systems compromised or used by the attacker to ensure all compromised accounts are identified. Reset passwords for these accounts and other potentially compromised credentials, such as email, business systems, and web services.
- Ensure that SQL servers are not directly exposed to the internet. If there is a business justification for such, use an allowlist to allow only connections from known legitimate sources.
- Disable the xp_cmdshell stored procedure.
- Run a full antimalware scan. This may reveal additional artifacts left in the system, persistence mechanisms, and malware components.
- Determine the initial vector abused by the attacker and take action to prevent reinfection through the same vector.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```kuery
host.os.type:windows and event.category:process and event.type:start and
process.parent.name:"sqlservr.exe" and process.command_line : * and
(
  (
    (process.name.caseless : "cmd.exe" or process.pe.original_file_name : "Cmd.Exe") and
    not process.args : (
          \\\\* or diskfree or rmdir or mkdir or dir or DIR or del or rename or bcp or md or ren or REN or send or echo or
          ECHO or TYPE or type or EXIST or forfiles or sqlcmd or SQLCMD or dtexec or Sort-Object or cat or copy or COPY or
          move or MOVE or CD\\ or show or rd or powercfg or "C:\SPAN4\DATA\RISKPARAM.SPN" or ("@ECHO" and "@FOR") or
          ("@echo" and "@for") or (SET and PATH=*) or ("-ExecutionPolicy" and "-File") or MSSQLFDLauncher$DATEV_DBENGINE or
          (wmic and (cpu or computersystem or logicaldisk or os or ComputerSystem or volume)) or -s\:C\:\\WINDOWS\\SERVIC* or
          D\:\\* or E\:\\* or F\:\\* or Z\:\\* or "C:\Program Files\Amazon\AWSCLIV2\aws.exe" or C\:\\7-Zip\\7z.exe* or
          C\:\\FTP* or *\(Get-Item* or C\:\\ProgramData\\Daktronics*
    ) and
    not process.command_line : (
          "\"C:\\Windows\\system32\\cmd.exe\" /c " or
          "\"C:\\Windows\\System32\\cmd.exe\""
    )
  ) or
  process.name.caseless:("bitsadmin.exe" or "certutil.exe" or "vpnbridge.exe") or
  process.name:("bitsadmin.exe" or "certutil.exe" or "vpnbridge.exe") or
  process.pe.original_file_name:("CertUtil.exe" or "bitsadmin.exe" or "vpnbridge.exe")
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Server Software Component
- Id: T1505
- Reference URL: [[https://attack.mitre.org/techniques/T1505/](https://attack.mitre.org/techniques/T1505/)](https://attack.mitre.org/techniques/T1505/)
- Sub Technique:
  - Name: SQL Stored Procedures
- Id: T1505.001
- Reference URL: [[https://attack.mitre.org/techniques/T1505/001/](https://attack.mitre.org/techniques/T1505/001/)](https://attack.mitre.org/techniques/T1505/001/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: Windows Command Shell
- Id: T1059.003
- Reference URL: [[https://attack.mitre.org/techniques/T1059/003/](https://attack.mitre.org/techniques/T1059/003/)](https://attack.mitre.org/techniques/T1059/003/)